/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.digitalocean2.compute.extensions;

import com.google.common.base.Function;
import com.google.common.base.Preconditions;
import com.google.common.base.Predicate;
import com.google.common.primitives.Ints;
import com.google.common.util.concurrent.ListenableFuture;
import com.google.common.util.concurrent.ListeningExecutorService;
import com.google.common.util.concurrent.UncheckedTimeoutException;
import jakarta.annotation.Resource;
import jakarta.inject.Inject;
import jakarta.inject.Named;
import jakarta.inject.Singleton;
import java.util.NoSuchElementException;
import java.util.concurrent.Callable;
import org.jclouds.compute.domain.CloneImageTemplate;
import org.jclouds.compute.domain.ImageTemplate;
import org.jclouds.compute.domain.ImageTemplateBuilder;
import org.jclouds.compute.extensions.ImageExtension;
import org.jclouds.digitalocean2.DigitalOcean2Api;
import org.jclouds.digitalocean2.compute.internal.ImageInRegion;
import org.jclouds.digitalocean2.domain.Action;
import org.jclouds.digitalocean2.domain.Droplet;
import org.jclouds.digitalocean2.domain.Image;
import org.jclouds.logging.Logger;

@Singleton
public class DigitalOcean2ImageExtension
implements ImageExtension {
    @Resource
    @Named(value="jclouds.compute")
    protected Logger logger = Logger.NULL;
    private final DigitalOcean2Api api;
    private final Predicate<Integer> imageAvailablePredicate;
    private final Predicate<Integer> nodeRunningPredicate;
    private final Function<ImageInRegion, org.jclouds.compute.domain.Image> imageTransformer;
    private final ListeningExecutorService userExecutor;

    @Inject
    DigitalOcean2ImageExtension(DigitalOcean2Api api, @Named(value="jclouds.compute.timeout.image-available") Predicate<Integer> imageAvailablePredicate, @Named(value="jclouds.compute.timeout.node-running") Predicate<Integer> nodeRunningPredicate, Function<ImageInRegion, org.jclouds.compute.domain.Image> imageTransformer, @Named(value="jclouds.user-threads") ListeningExecutorService userExecutor) {
        this.api = api;
        this.imageAvailablePredicate = imageAvailablePredicate;
        this.nodeRunningPredicate = nodeRunningPredicate;
        this.imageTransformer = imageTransformer;
        this.userExecutor = userExecutor;
    }

    public ImageTemplate buildImageTemplateFromNode(String name, String id) {
        Droplet droplet = this.api.dropletApi().get(Integer.parseInt(id));
        if (droplet == null) {
            throw new NoSuchElementException("Cannot find droplet with id: " + id);
        }
        return new ImageTemplateBuilder.CloneImageTemplateBuilder().nodeId(id).name(name).build();
    }

    public ListenableFuture<org.jclouds.compute.domain.Image> createImage(ImageTemplate template) {
        Preconditions.checkState((boolean)(template instanceof CloneImageTemplate), (Object)"DigitalOcean only supports creating images through cloning.");
        final CloneImageTemplate cloneTemplate = (CloneImageTemplate)template;
        int dropletId = Integer.parseInt(cloneTemplate.getSourceNodeId());
        final Droplet droplet = this.api.dropletApi().get(dropletId);
        if (droplet.status() != Droplet.Status.ACTIVE) {
            this.api.dropletApi().powerOn(dropletId);
            Preconditions.checkState((boolean)this.nodeRunningPredicate.apply((Object)dropletId), (Object)"node was not powered on in the configured timeout");
        }
        final Action snapshotEvent = this.api.dropletApi().snapshot(Integer.parseInt(cloneTemplate.getSourceNodeId()), cloneTemplate.getName());
        this.logger.info(">> registered new Image, waiting for it to become available", new Object[0]);
        return this.userExecutor.submit((Callable)new Callable<org.jclouds.compute.domain.Image>(){

            @Override
            public org.jclouds.compute.domain.Image call() throws Exception {
                if (DigitalOcean2ImageExtension.this.imageAvailablePredicate.apply((Object)snapshotEvent.id())) {
                    Image snapshot = (Image)DigitalOcean2ImageExtension.this.api.imageApi().list().concat().firstMatch((Predicate)new Predicate<Image>(){

                        public boolean apply(Image input) {
                            return input.name().equals(cloneTemplate.getName());
                        }
                    }).get();
                    return (org.jclouds.compute.domain.Image)DigitalOcean2ImageExtension.this.imageTransformer.apply((Object)ImageInRegion.create(snapshot, droplet.region().slug()));
                }
                throw new UncheckedTimeoutException("Image was not created within the time limit: " + cloneTemplate.getName());
            }
        });
    }

    public boolean deleteImage(String id) {
        String imageId = ImageInRegion.extractImageId(id);
        Integer numericId = Ints.tryParse((String)imageId);
        if (numericId != null) {
            try {
                this.logger.debug(">> deleting image %s...", new Object[]{id});
                this.api.imageApi().delete(numericId);
                return true;
            }
            catch (Exception ex) {
                this.logger.error((Throwable)ex, ">> error deleting image %s", new Object[]{id});
            }
        } else {
            this.logger.warn(">> image %s is not a user image and cannot be deleted", new Object[]{id});
        }
        return false;
    }
}

