/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.azurecompute.arm.features;

import jakarta.inject.Named;
import jakarta.ws.rs.Consumes;
import jakarta.ws.rs.DELETE;
import jakarta.ws.rs.GET;
import jakarta.ws.rs.PUT;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.PathParam;
import jakarta.ws.rs.QueryParam;
import java.util.List;
import java.util.Map;
import org.jclouds.Fallbacks;
import org.jclouds.azurecompute.arm.domain.IpAddressAvailabilityResult;
import org.jclouds.azurecompute.arm.domain.VirtualNetwork;
import org.jclouds.azurecompute.arm.filters.ApiVersionFilter;
import org.jclouds.azurecompute.arm.functions.FalseOn204;
import org.jclouds.javax.annotation.Nullable;
import org.jclouds.oauth.v2.filters.OAuthFilter;
import org.jclouds.rest.annotations.Fallback;
import org.jclouds.rest.annotations.MapBinder;
import org.jclouds.rest.annotations.PayloadParam;
import org.jclouds.rest.annotations.RequestFilters;
import org.jclouds.rest.annotations.ResponseParser;
import org.jclouds.rest.annotations.SelectJson;
import org.jclouds.rest.binders.BindToJsonPayload;

@Path(value="")
@RequestFilters(value={OAuthFilter.class, ApiVersionFilter.class})
@Consumes(value={"application/json"})
public interface VirtualNetworkApi {
    @Named(value="virtualnetwork:list")
    @Path(value="/resourcegroups/{resourcegroup}/providers/Microsoft.Network/virtualNetworks")
    @SelectJson(value={"value"})
    @GET
    @Fallback(value=Fallbacks.EmptyListOnNotFoundOr404.class)
    public List<VirtualNetwork> list();

    @Named(value="loadbalancer:listall")
    @GET
    @Path(value="/providers/Microsoft.Network/virtualNetworks")
    @SelectJson(value={"value"})
    @Fallback(value=Fallbacks.EmptyListOnNotFoundOr404.class)
    public List<VirtualNetwork> listAll();

    @Named(value="virtualnetwork:create_or_update")
    @Path(value="/resourcegroups/{resourcegroup}/providers/Microsoft.Network/virtualNetworks/{virtualnetworkname}")
    @MapBinder(value=BindToJsonPayload.class)
    @PUT
    public VirtualNetwork createOrUpdate(@PathParam(value="virtualnetworkname") String var1, @PayloadParam(value="location") String var2, @Nullable @PayloadParam(value="tags") Map<String, String> var3, @PayloadParam(value="properties") VirtualNetwork.VirtualNetworkProperties var4);

    @Named(value="virtualnetwork:get")
    @Path(value="/resourcegroups/{resourcegroup}/providers/Microsoft.Network/virtualNetworks/{virtualnetworkname}")
    @GET
    @Fallback(value=Fallbacks.NullOnNotFoundOr404.class)
    public VirtualNetwork get(@PathParam(value="virtualnetworkname") String var1);

    @Named(value="virtualnetwork:delete")
    @Path(value="/resourcegroups/{resourcegroup}/providers/Microsoft.Network/virtualNetworks/{virtualnetworkname}")
    @DELETE
    @ResponseParser(value=FalseOn204.class)
    public boolean delete(@PathParam(value="virtualnetworkname") String var1);

    @Named(value="virtualnetwork:check_ip_address_availability")
    @Path(value="/resourcegroups/{resourcegroup}/providers/Microsoft.Network/virtualNetworks/{virtualnetworkname}/CheckIPAddressAvailability")
    @GET
    public IpAddressAvailabilityResult checkIPAddressAvailability(@PathParam(value="virtualnetworkname") String var1, @QueryParam(value="ipAddress") String var2);
}

