/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.azurecompute.arm.features;

import com.google.common.base.Function;
import jakarta.inject.Named;
import jakarta.ws.rs.Consumes;
import jakarta.ws.rs.DELETE;
import jakarta.ws.rs.GET;
import jakarta.ws.rs.POST;
import jakarta.ws.rs.PUT;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.PathParam;
import java.net.URI;
import java.util.List;
import java.util.Map;
import org.jclouds.Fallbacks;
import org.jclouds.azurecompute.arm.config.OAuthResource;
import org.jclouds.azurecompute.arm.domain.Certificate;
import org.jclouds.azurecompute.arm.domain.Key;
import org.jclouds.azurecompute.arm.domain.Secret;
import org.jclouds.azurecompute.arm.domain.Vault;
import org.jclouds.azurecompute.arm.domain.VaultProperties;
import org.jclouds.azurecompute.arm.filters.ApiVersionFilter;
import org.jclouds.javax.annotation.Nullable;
import org.jclouds.oauth.v2.filters.OAuthFilter;
import org.jclouds.rest.annotations.EndpointParam;
import org.jclouds.rest.annotations.Fallback;
import org.jclouds.rest.annotations.MapBinder;
import org.jclouds.rest.annotations.PATCH;
import org.jclouds.rest.annotations.ParamParser;
import org.jclouds.rest.annotations.PayloadParam;
import org.jclouds.rest.annotations.RequestFilters;
import org.jclouds.rest.annotations.SelectJson;
import org.jclouds.rest.binders.BindToJsonPayload;

@RequestFilters(value={OAuthFilter.class, ApiVersionFilter.class})
@Consumes(value={"application/json"})
public interface VaultApi {
    public static final String VAULT_API_STANDARD_ENDPOINT = "https://vault.azure.net";
    public static final String VAULT_API_CHINA_ENDPOINT = "https://vault.azure.cn";

    @Named(value="vault:list")
    @SelectJson(value={"value"})
    @GET
    @Path(value="/resourcegroups/{resourcegroup}/providers/Microsoft.KeyVault/vaults")
    @Fallback(value=Fallbacks.EmptyListOnNotFoundOr404.class)
    public List<Vault> listVaults();

    @Named(value="vault:create_or_update")
    @PUT
    @MapBinder(value=BindToJsonPayload.class)
    @Path(value="/resourcegroups/{resourcegroup}/providers/Microsoft.KeyVault/vaults/{vaultName}")
    public Vault createOrUpdateVault(@PathParam(value="vaultName") String var1, @PayloadParam(value="location") String var2, @PayloadParam(value="properties") VaultProperties var3, @Nullable @PayloadParam(value="tags") Map<String, String> var4);

    @Named(value="vault:get")
    @Path(value="/resourcegroups/{resourcegroup}/providers/Microsoft.KeyVault/vaults/{vaultName}")
    @GET
    @Fallback(value=Fallbacks.NullOnNotFoundOr404.class)
    public Vault getVault(@PathParam(value="vaultName") String var1);

    @Named(value="vault:delete")
    @Path(value="/resourcegroups/{resourcegroup}/providers/Microsoft.KeyVault/vaults/{vaultName}")
    @DELETE
    @Fallback(value=Fallbacks.FalseOnNotFoundOr404.class)
    public boolean deleteVault(@PathParam(value="vaultName") String var1);

    @Named(value="vault:list_deleted_vaults")
    @Path(value="/providers/Microsoft.KeyVault/deletedVaults")
    @GET
    @SelectJson(value={"value"})
    @Fallback(value=Fallbacks.EmptyListOnNotFoundOr404.class)
    public List<Vault.DeletedVault> listDeletedVaults();

    @Named(value="vault:get_deleted")
    @GET
    @Path(value="/providers/Microsoft.KeyVault/locations/{location}/deletedVaults/{vaultName}")
    @Fallback(value=Fallbacks.NullOnNotFoundOr404.class)
    public Vault.DeletedVault getDeletedVault(@PathParam(value="location") String var1, @PathParam(value="vaultName") String var2);

    @Named(value="vault:purge")
    @POST
    @Fallback(value=Fallbacks.FalseOnNotFoundOr404.class)
    @Path(value="/providers/Microsoft.KeyVault/locations/{location}/deletedVaults/{vaultName}/purge")
    public boolean purgeVault(@PathParam(value="location") String var1, @PathParam(value="vaultName") String var2);

    @Named(value="key:list")
    @SelectJson(value={"value"})
    @GET
    @Fallback(value=Fallbacks.EmptyListOnNotFoundOr404.class)
    @Path(value="/keys")
    @OAuthResource(value="https://vault.azure.net", chinaEndpoint="https://vault.azure.cn")
    public List<Key> listKeys(@EndpointParam URI var1);

    @Named(value="key:create")
    @POST
    @MapBinder(value=BindToJsonPayload.class)
    @Path(value="/keys/{keyName}/create")
    @OAuthResource(value="https://vault.azure.net", chinaEndpoint="https://vault.azure.cn")
    public Key.KeyBundle createKey(@EndpointParam URI var1, @PathParam(value="keyName") String var2, @Nullable @PayloadParam(value="attributes") Key.KeyAttributes var3, @Nullable @PayloadParam(value="crv") String var4, @Nullable @PayloadParam(value="key_ops") List<String> var5, @PayloadParam(value="key_size") int var6, @PayloadParam(value="kty") String var7, @Nullable @PayloadParam(value="tags") Map<String, String> var8);

    @Named(value="key:import")
    @PUT
    @MapBinder(value=BindToJsonPayload.class)
    @Path(value="/keys/{keyName}")
    @OAuthResource(value="https://vault.azure.net", chinaEndpoint="https://vault.azure.cn")
    public Key.KeyBundle importKey(@EndpointParam URI var1, @PathParam(value="keyName") String var2, @PayloadParam(value="Hsm") boolean var3, @Nullable @PayloadParam(value="attributes") Key.KeyAttributes var4, @Nullable @PayloadParam(value="key") Key.JsonWebKey var5, @Nullable @PayloadParam(value="tags") Map<String, String> var6);

    @Named(value="key:get")
    @GET
    @Path(value="/keys/{keyName}")
    @Fallback(value=Fallbacks.NullOnNotFoundOr404.class)
    @OAuthResource(value="https://vault.azure.net", chinaEndpoint="https://vault.azure.cn")
    public Key.KeyBundle getKey(@EndpointParam URI var1, @PathParam(value="keyName") String var2);

    @Named(value="key:delete")
    @DELETE
    @Path(value="/keys/{keyName}")
    @Fallback(value=Fallbacks.NullOnNotFoundOr404.class)
    @OAuthResource(value="https://vault.azure.net", chinaEndpoint="https://vault.azure.cn")
    public Key.DeletedKeyBundle deleteKey(@EndpointParam URI var1, @PathParam(value="keyName") String var2);

    @Named(value="key:get_versions")
    @GET
    @SelectJson(value={"value"})
    @Path(value="/keys/{keyName}/versions")
    @Fallback(value=Fallbacks.EmptyListOnNotFoundOr404.class)
    @OAuthResource(value="https://vault.azure.net", chinaEndpoint="https://vault.azure.cn")
    public List<Key> getKeyVersions(@EndpointParam URI var1, @PathParam(value="keyName") String var2);

    @Named(value="key:update")
    @PATCH
    @MapBinder(value=BindToJsonPayload.class)
    @Path(value="/keys/{keyName}{keyVersion}")
    @OAuthResource(value="https://vault.azure.net", chinaEndpoint="https://vault.azure.cn")
    public Key.KeyBundle updateKey(@EndpointParam URI var1, @PathParam(value="keyName") String var2, @Nullable @PathParam(value="keyVersion") @ParamParser(value=PrependSlashOrEmptyString.class) String var3, @Nullable @PayloadParam(value="attributes") Key.KeyAttributes var4, @Nullable @PayloadParam(value="key_ops") List<String> var5, @Nullable @PayloadParam(value="tags") Map<String, String> var6);

    @Named(value="key:backup")
    @POST
    @SelectJson(value={"value"})
    @Path(value="/keys/{keyName}/backup")
    @OAuthResource(value="https://vault.azure.net", chinaEndpoint="https://vault.azure.cn")
    public String backupKey(@EndpointParam URI var1, @PathParam(value="keyName") String var2);

    @Named(value="key:restore")
    @POST
    @MapBinder(value=BindToJsonPayload.class)
    @Path(value="/keys/restore")
    @OAuthResource(value="https://vault.azure.net", chinaEndpoint="https://vault.azure.cn")
    public Key.KeyBundle restoreKey(@EndpointParam URI var1, @PayloadParam(value="value") String var2);

    @Named(value="key:list_deleted")
    @GET
    @SelectJson(value={"value"})
    @Path(value="/deletedkeys")
    @Fallback(value=Fallbacks.EmptyListOnNotFoundOr404.class)
    @OAuthResource(value="https://vault.azure.net", chinaEndpoint="https://vault.azure.cn")
    public List<Key.DeletedKeyBundle> listDeletedKeys(@EndpointParam URI var1);

    @Named(value="key:get_deleted")
    @GET
    @Path(value="/deletedkeys/{keyName}")
    @Fallback(value=Fallbacks.NullOnNotFoundOr404.class)
    @OAuthResource(value="https://vault.azure.net", chinaEndpoint="https://vault.azure.cn")
    public Key.DeletedKeyBundle getDeletedKey(@EndpointParam URI var1, @PathParam(value="keyName") String var2);

    @Named(value="key:recover_deleted")
    @POST
    @Path(value="/deletedkeys/{keyName}/recover")
    @OAuthResource(value="https://vault.azure.net", chinaEndpoint="https://vault.azure.cn")
    public Key.KeyBundle recoverDeletedKey(@EndpointParam URI var1, @PathParam(value="keyName") String var2);

    @Named(value="key:purge_deleted")
    @DELETE
    @Path(value="/deletedkeys/{keyName}")
    @Fallback(value=Fallbacks.FalseOnNotFoundOr404.class)
    @OAuthResource(value="https://vault.azure.net", chinaEndpoint="https://vault.azure.cn")
    public boolean purgeDeletedKey(@EndpointParam URI var1, @PathParam(value="keyName") String var2);

    @Named(value="key:crypto_encrypt")
    @POST
    @Path(value="/keys/{keyName}{keyVersion}/encrypt")
    @MapBinder(value=BindToJsonPayload.class)
    @OAuthResource(value="https://vault.azure.net", chinaEndpoint="https://vault.azure.cn")
    public Key.KeyOperationResult encrypt(@EndpointParam URI var1, @PathParam(value="keyName") String var2, @Nullable @PathParam(value="keyVersion") @ParamParser(value=PrependSlashOrEmptyString.class) String var3, @PayloadParam(value="alg") String var4, @PayloadParam(value="value") String var5);

    @Named(value="key:crypto_decrypt")
    @POST
    @Path(value="/keys/{keyName}{keyVersion}/decrypt")
    @MapBinder(value=BindToJsonPayload.class)
    @OAuthResource(value="https://vault.azure.net", chinaEndpoint="https://vault.azure.cn")
    public Key.KeyOperationResult decrypt(@EndpointParam URI var1, @PathParam(value="keyName") String var2, @Nullable @PathParam(value="keyVersion") @ParamParser(value=PrependSlashOrEmptyString.class) String var3, @PayloadParam(value="alg") String var4, @PayloadParam(value="value") String var5);

    @Named(value="key:crypto_sign")
    @POST
    @Path(value="/keys/{keyName}{keyVersion}/sign")
    @MapBinder(value=BindToJsonPayload.class)
    @OAuthResource(value="https://vault.azure.net", chinaEndpoint="https://vault.azure.cn")
    public Key.KeyOperationResult sign(@EndpointParam URI var1, @PathParam(value="keyName") String var2, @Nullable @PathParam(value="keyVersion") @ParamParser(value=PrependSlashOrEmptyString.class) String var3, @PayloadParam(value="alg") String var4, @PayloadParam(value="value") String var5);

    @Named(value="key:crypto_verify")
    @POST
    @Path(value="/keys/{keyName}{keyVersion}/verify")
    @MapBinder(value=BindToJsonPayload.class)
    @OAuthResource(value="https://vault.azure.net", chinaEndpoint="https://vault.azure.cn")
    public boolean verify(@EndpointParam URI var1, @PathParam(value="keyName") String var2, @Nullable @PathParam(value="keyVersion") @ParamParser(value=PrependSlashOrEmptyString.class) String var3, @PayloadParam(value="alg") String var4, @PayloadParam(value="digest") String var5, @PayloadParam(value="value") String var6);

    @Named(value="key:crypto_wrap")
    @POST
    @Path(value="/keys/{keyName}{keyVersion}/wrapkey")
    @MapBinder(value=BindToJsonPayload.class)
    @OAuthResource(value="https://vault.azure.net", chinaEndpoint="https://vault.azure.cn")
    public Key.KeyOperationResult wrap(@EndpointParam URI var1, @PathParam(value="keyName") String var2, @Nullable @PathParam(value="keyVersion") @ParamParser(value=PrependSlashOrEmptyString.class) String var3, @PayloadParam(value="alg") String var4, @PayloadParam(value="value") String var5);

    @Named(value="key:crypto_unwrap")
    @POST
    @Path(value="/keys/{keyName}{keyVersion}/unwrapkey")
    @MapBinder(value=BindToJsonPayload.class)
    @OAuthResource(value="https://vault.azure.net", chinaEndpoint="https://vault.azure.cn")
    public Key.KeyOperationResult unwrap(@EndpointParam URI var1, @PathParam(value="keyName") String var2, @Nullable @PathParam(value="keyVersion") @ParamParser(value=PrependSlashOrEmptyString.class) String var3, @PayloadParam(value="alg") String var4, @PayloadParam(value="value") String var5);

    @Named(value="secret:list")
    @SelectJson(value={"value"})
    @GET
    @Fallback(value=Fallbacks.EmptyListOnNotFoundOr404.class)
    @Path(value="/secrets")
    @OAuthResource(value="https://vault.azure.net", chinaEndpoint="https://vault.azure.cn")
    public List<Secret> listSecrets(@EndpointParam URI var1);

    @Named(value="secret:set")
    @PUT
    @MapBinder(value=BindToJsonPayload.class)
    @Path(value="/secrets/{secretName}")
    @OAuthResource(value="https://vault.azure.net", chinaEndpoint="https://vault.azure.cn")
    public Secret.SecretBundle setSecret(@EndpointParam URI var1, @PathParam(value="secretName") String var2, @Nullable @PayloadParam(value="attributes") Secret.SecretAttributes var3, @Nullable @PayloadParam(value="contentType") String var4, @Nullable @PayloadParam(value="tags") Map<String, String> var5, @PayloadParam(value="value") String var6);

    @Named(value="secret:get")
    @GET
    @Path(value="/secrets/{secretName}{secretVersion}")
    @Fallback(value=Fallbacks.NullOnNotFoundOr404.class)
    @OAuthResource(value="https://vault.azure.net", chinaEndpoint="https://vault.azure.cn")
    public Secret.SecretBundle getSecret(@EndpointParam URI var1, @PathParam(value="secretName") String var2, @Nullable @PathParam(value="secretVersion") @ParamParser(value=PrependSlashOrEmptyString.class) String var3);

    @Named(value="secret:delete")
    @DELETE
    @Path(value="/secrets/{secretName}")
    @Fallback(value=Fallbacks.NullOnNotFoundOr404.class)
    @OAuthResource(value="https://vault.azure.net", chinaEndpoint="https://vault.azure.cn")
    public Secret.DeletedSecretBundle deleteSecret(@EndpointParam URI var1, @PathParam(value="secretName") String var2);

    @Named(value="secret:get_versions")
    @GET
    @SelectJson(value={"value"})
    @Path(value="/secrets/{secretName}/versions")
    @Fallback(value=Fallbacks.EmptyListOnNotFoundOr404.class)
    @OAuthResource(value="https://vault.azure.net", chinaEndpoint="https://vault.azure.cn")
    public List<Secret> getSecretVersions(@EndpointParam URI var1, @PathParam(value="secretName") String var2);

    @Named(value="secret:update")
    @PATCH
    @MapBinder(value=BindToJsonPayload.class)
    @Path(value="/secrets/{secretName}{secretVersion}")
    @OAuthResource(value="https://vault.azure.net", chinaEndpoint="https://vault.azure.cn")
    public Secret.SecretBundle updateSecret(@EndpointParam URI var1, @PathParam(value="secretName") String var2, @Nullable @PathParam(value="secretVersion") @ParamParser(value=PrependSlashOrEmptyString.class) String var3, @Nullable @PayloadParam(value="attributes") Secret.SecretAttributes var4, @Nullable @PayloadParam(value="contentType") String var5, @Nullable @PayloadParam(value="tags") Map<String, String> var6);

    @Named(value="secret:backup")
    @POST
    @SelectJson(value={"value"})
    @Path(value="/secrets/{secretName}/backup")
    @OAuthResource(value="https://vault.azure.net", chinaEndpoint="https://vault.azure.cn")
    public String backupSecret(@EndpointParam URI var1, @PathParam(value="secretName") String var2);

    @Named(value="secret:restore")
    @POST
    @MapBinder(value=BindToJsonPayload.class)
    @Path(value="/secrets/restore")
    @OAuthResource(value="https://vault.azure.net", chinaEndpoint="https://vault.azure.cn")
    public Secret.SecretBundle restoreSecret(@EndpointParam URI var1, @PayloadParam(value="value") String var2);

    @Named(value="secret:list_deleted")
    @GET
    @SelectJson(value={"value"})
    @Path(value="/deletedsecrets")
    @Fallback(value=Fallbacks.EmptyListOnNotFoundOr404.class)
    @OAuthResource(value="https://vault.azure.net", chinaEndpoint="https://vault.azure.cn")
    public List<Secret.DeletedSecretBundle> listDeletedSecrets(@EndpointParam URI var1);

    @Named(value="secret:get_deleted")
    @GET
    @Path(value="/deletedsecrets/{secretName}")
    @Fallback(value=Fallbacks.NullOnNotFoundOr404.class)
    @OAuthResource(value="https://vault.azure.net", chinaEndpoint="https://vault.azure.cn")
    public Secret.DeletedSecretBundle getDeletedSecret(@EndpointParam URI var1, @PathParam(value="secretName") String var2);

    @Named(value="secret:recover_deleted")
    @POST
    @Path(value="/deletedsecrets/{secretName}/recover")
    @OAuthResource(value="https://vault.azure.net", chinaEndpoint="https://vault.azure.cn")
    public Secret.SecretBundle recoverDeletedSecret(@EndpointParam URI var1, @PathParam(value="secretName") String var2);

    @Named(value="secret:purge_deleted")
    @DELETE
    @Path(value="/deletedsecrets/{secretName}")
    @Fallback(value=Fallbacks.FalseOnNotFoundOr404.class)
    @OAuthResource(value="https://vault.azure.net", chinaEndpoint="https://vault.azure.cn")
    public boolean purgeDeletedSecret(@EndpointParam URI var1, @PathParam(value="secretName") String var2);

    @Named(value="certificate:create")
    @POST
    @MapBinder(value=BindToJsonPayload.class)
    @Path(value="/certificates/{certificateName}/create")
    @OAuthResource(value="https://vault.azure.net", chinaEndpoint="https://vault.azure.cn")
    public Certificate.CertificateOperation createCertificate(@EndpointParam URI var1, @PathParam(value="certificateName") String var2, @Nullable @PayloadParam(value="attributes") Certificate.CertificateAttributes var3, @Nullable @PayloadParam(value="policy") Certificate.CertificatePolicy var4, @Nullable @PayloadParam(value="tags") Map<String, String> var5);

    @Named(value="certificate:get")
    @GET
    @Path(value="/certificates/{certificateName}{certificateVersion}")
    @Fallback(value=Fallbacks.NullOnNotFoundOr404.class)
    @OAuthResource(value="https://vault.azure.net", chinaEndpoint="https://vault.azure.cn")
    public Certificate.CertificateBundle getCertificate(@EndpointParam URI var1, @PathParam(value="certificateName") String var2, @Nullable @PathParam(value="certificateVersion") @ParamParser(value=PrependSlashOrEmptyString.class) String var3);

    @Named(value="certificate:delete")
    @DELETE
    @Path(value="/certificates/{certificateName}")
    @Fallback(value=Fallbacks.NullOnNotFoundOr404.class)
    @OAuthResource(value="https://vault.azure.net", chinaEndpoint="https://vault.azure.cn")
    public Certificate.DeletedCertificateBundle deleteCertificate(@EndpointParam URI var1, @PathParam(value="certificateName") String var2);

    @Named(value="certificate:list")
    @GET
    @SelectJson(value={"value"})
    @Path(value="/certificates")
    @Fallback(value=Fallbacks.EmptyListOnNotFoundOr404.class)
    @OAuthResource(value="https://vault.azure.net", chinaEndpoint="https://vault.azure.cn")
    public List<Certificate> getCertificates(@EndpointParam URI var1);

    @Named(value="certificate:list_deleted")
    @GET
    @SelectJson(value={"value"})
    @Path(value="/deletedcertificates")
    @Fallback(value=Fallbacks.EmptyListOnNotFoundOr404.class)
    @OAuthResource(value="https://vault.azure.net", chinaEndpoint="https://vault.azure.cn")
    public List<Certificate.DeletedCertificate> getDeletedCertificates(@EndpointParam URI var1);

    @Named(value="certificate:get_deleted")
    @GET
    @Path(value="/deletedcertificates/{certificateName}")
    @Fallback(value=Fallbacks.NullOnNotFoundOr404.class)
    @OAuthResource(value="https://vault.azure.net", chinaEndpoint="https://vault.azure.cn")
    public Certificate.DeletedCertificateBundle getDeletedCertificate(@EndpointParam URI var1, @PathParam(value="certificateName") String var2);

    @Named(value="certificate:recover_deleted")
    @POST
    @Path(value="/deletedcertificates/{certificateName}/recover")
    @OAuthResource(value="https://vault.azure.net", chinaEndpoint="https://vault.azure.cn")
    public Certificate.CertificateBundle recoverDeletedCertificate(@EndpointParam URI var1, @PathParam(value="certificateName") String var2);

    @Named(value="certificate:purge_deleted")
    @DELETE
    @Path(value="/deletedcertificates/{certificateName}")
    @Fallback(value=Fallbacks.FalseOnNotFoundOr404.class)
    @OAuthResource(value="https://vault.azure.net", chinaEndpoint="https://vault.azure.cn")
    public boolean purgeDeletedCertificate(@EndpointParam URI var1, @PathParam(value="certificateName") String var2);

    @Named(value="certificate:get_versions")
    @GET
    @SelectJson(value={"value"})
    @Path(value="/certificates/{certificateName}/versions")
    @Fallback(value=Fallbacks.EmptyListOnNotFoundOr404.class)
    @OAuthResource(value="https://vault.azure.net", chinaEndpoint="https://vault.azure.cn")
    public List<Certificate> getCertificateVersions(@EndpointParam URI var1, @PathParam(value="certificateName") String var2);

    @Named(value="certificate:update")
    @PATCH
    @MapBinder(value=BindToJsonPayload.class)
    @Path(value="/certificates/{certificateName}{certificateVersion}")
    @OAuthResource(value="https://vault.azure.net", chinaEndpoint="https://vault.azure.cn")
    public Certificate.CertificateBundle updateCertificate(@EndpointParam URI var1, @PathParam(value="certificateName") String var2, @Nullable @PathParam(value="certificateVersion") @ParamParser(value=PrependSlashOrEmptyString.class) String var3, @Nullable @PayloadParam(value="attributes") Certificate.CertificateAttributes var4, @Nullable @PayloadParam(value="policy") Certificate.CertificatePolicy var5, @Nullable @PayloadParam(value="tags") Map<String, String> var6);

    @Named(value="certificate:import")
    @POST
    @MapBinder(value=BindToJsonPayload.class)
    @Path(value="/certificates/{certificateName}/import")
    @OAuthResource(value="https://vault.azure.net", chinaEndpoint="https://vault.azure.cn")
    public Certificate.CertificateBundle importCertificate(@EndpointParam URI var1, @PathParam(value="certificateName") String var2, @Nullable @PayloadParam(value="attributes") Certificate.CertificateAttributes var3, @Nullable @PayloadParam(value="policy") Certificate.CertificatePolicy var4, @Nullable @PayloadParam(value="pwd") String var5, @Nullable @PayloadParam(value="tags") Map<String, String> var6, @PayloadParam(value="value") String var7);

    @Named(value="certificate:merge")
    @POST
    @MapBinder(value=BindToJsonPayload.class)
    @Path(value="/certificates/{certificateName}/pending/merge")
    @OAuthResource(value="https://vault.azure.net", chinaEndpoint="https://vault.azure.cn")
    public Certificate.CertificateBundle mergeCertificate(@EndpointParam URI var1, @PathParam(value="certificateName") String var2, @Nullable @PayloadParam(value="attributes") Certificate.CertificateAttributes var3, @Nullable @PayloadParam(value="tags") Map<String, String> var4, @PayloadParam(value="x5c") List<String> var5);

    @Named(value="certificate:get_operation")
    @GET
    @Path(value="/certificates/{certificateName}/pending")
    @Fallback(value=Fallbacks.NullOnNotFoundOr404.class)
    @OAuthResource(value="https://vault.azure.net", chinaEndpoint="https://vault.azure.cn")
    public Certificate.CertificateOperation getCertificateOperation(@EndpointParam URI var1, @PathParam(value="certificateName") String var2);

    @Named(value="certificate:update_operation")
    @PATCH
    @Path(value="/certificates/{certificateName}/pending")
    @MapBinder(value=BindToJsonPayload.class)
    @OAuthResource(value="https://vault.azure.net", chinaEndpoint="https://vault.azure.cn")
    public Certificate.CertificateOperation updateCertificateOperation(@EndpointParam URI var1, @PathParam(value="certificateName") String var2, @PayloadParam(value="cancellation_requested") boolean var3);

    @Named(value="certificate:delete_operation")
    @DELETE
    @Path(value="/certificates/{certificateName}/pending")
    @Fallback(value=Fallbacks.NullOnNotFoundOr404.class)
    @OAuthResource(value="https://vault.azure.net", chinaEndpoint="https://vault.azure.cn")
    public Certificate.CertificateOperation deleteCertificateOperation(@EndpointParam URI var1, @PathParam(value="certificateName") String var2);

    @Named(value="certificate:set_issuer")
    @PUT
    @Path(value="/certificates/issuers/{issuerName}")
    @MapBinder(value=BindToJsonPayload.class)
    @OAuthResource(value="https://vault.azure.net", chinaEndpoint="https://vault.azure.cn")
    public Certificate.IssuerBundle setCertificateIssuer(@EndpointParam URI var1, @PathParam(value="issuerName") String var2, @Nullable @PayloadParam(value="attributes") Certificate.IssuerAttributes var3, @Nullable @PayloadParam(value="credentials") Certificate.IssuerCredentials var4, @Nullable @PayloadParam(value="org_details") Certificate.OrganizationDetails var5, @PayloadParam(value="provider") String var6);

    @Named(value="certificate:get_issuers")
    @GET
    @SelectJson(value={"value"})
    @Path(value="/certificates/issuers")
    @Fallback(value=Fallbacks.EmptyListOnNotFoundOr404.class)
    @OAuthResource(value="https://vault.azure.net", chinaEndpoint="https://vault.azure.cn")
    public List<Certificate.CertificateIssuer> getCertificateIssuers(@EndpointParam URI var1);

    @Named(value="certificate:get_issuer")
    @GET
    @Path(value="/certificates/issuers/{issuerName}")
    @Fallback(value=Fallbacks.NullOnNotFoundOr404.class)
    @OAuthResource(value="https://vault.azure.net", chinaEndpoint="https://vault.azure.cn")
    public Certificate.IssuerBundle getCertificateIssuer(@EndpointParam URI var1, @PathParam(value="issuerName") String var2);

    @Named(value="certificate:update_issuer")
    @PATCH
    @Path(value="/certificates/issuers/{issuerName}")
    @MapBinder(value=BindToJsonPayload.class)
    @OAuthResource(value="https://vault.azure.net", chinaEndpoint="https://vault.azure.cn")
    public Certificate.IssuerBundle updateCertificateIssuer(@EndpointParam URI var1, @PathParam(value="issuerName") String var2, @Nullable @PayloadParam(value="attributes") Certificate.IssuerAttributes var3, @Nullable @PayloadParam(value="credentials") Certificate.IssuerCredentials var4, @Nullable @PayloadParam(value="org_details") Certificate.OrganizationDetails var5, @PayloadParam(value="provider") String var6);

    @Named(value="certificate:delete_issuer")
    @DELETE
    @Path(value="/certificates/issuers/{issuerName}")
    @Fallback(value=Fallbacks.NullOnNotFoundOr404.class)
    @OAuthResource(value="https://vault.azure.net", chinaEndpoint="https://vault.azure.cn")
    public Certificate.IssuerBundle deleteCertificateIssuer(@EndpointParam URI var1, @PathParam(value="issuerName") String var2);

    @Named(value="certificate:get_contacts")
    @GET
    @Path(value="/certificates/contacts")
    @Fallback(value=Fallbacks.NullOnNotFoundOr404.class)
    @OAuthResource(value="https://vault.azure.net", chinaEndpoint="https://vault.azure.cn")
    public Certificate.Contacts getCertificateContacts(@EndpointParam URI var1);

    @Named(value="certificate:set_contacts")
    @PUT
    @Path(value="/certificates/contacts")
    @MapBinder(value=BindToJsonPayload.class)
    @OAuthResource(value="https://vault.azure.net", chinaEndpoint="https://vault.azure.cn")
    public Certificate.Contacts setCertificateContacts(@EndpointParam URI var1, @PayloadParam(value="contacts") List<Certificate.Contact> var2);

    @Named(value="certificate:delete_contacts")
    @DELETE
    @Path(value="/certificates/contacts")
    @Fallback(value=Fallbacks.NullOnNotFoundOr404.class)
    @OAuthResource(value="https://vault.azure.net", chinaEndpoint="https://vault.azure.cn")
    public Certificate.Contacts deleteCertificateContacts(@EndpointParam URI var1);

    @Named(value="certificate:get_policy")
    @GET
    @Path(value="/certificates/{certificateName}/policy")
    @Fallback(value=Fallbacks.NullOnNotFoundOr404.class)
    @OAuthResource(value="https://vault.azure.net", chinaEndpoint="https://vault.azure.cn")
    public Certificate.CertificatePolicy getCertificatePolicy(@EndpointParam URI var1, @PathParam(value="certificateName") String var2);

    @Named(value="certificate:update_policy")
    @PATCH
    @MapBinder(value=BindToJsonPayload.class)
    @Path(value="/certificates/{certificateName}/policy")
    @OAuthResource(value="https://vault.azure.net", chinaEndpoint="https://vault.azure.cn")
    public Certificate.CertificatePolicy updateCertificatePolicy(@EndpointParam URI var1, @PathParam(value="certificateName") String var2, @Nullable @PayloadParam(value="attributes") Certificate.CertificateAttributes var3, @Nullable @PayloadParam(value="issuer") Certificate.IssuerParameters var4, @Nullable @PayloadParam(value="key_props") Certificate.KeyProperties var5, @Nullable @PayloadParam(value="lifetime_actions") List<Certificate.LifetimeAction> var6, @Nullable @PayloadParam(value="secret_props") Certificate.SecretProperties var7, @Nullable @PayloadParam(value="x509_props") Certificate.X509CertificateProperties var8);

    public static class PrependSlashOrEmptyString
    implements Function<Object, String> {
        public String apply(Object from) {
            if (from == null || from.toString().length() == 0) {
                return "";
            }
            return "/" + from.toString();
        }
    }
}

