/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.azurecompute.arm.features;

import jakarta.inject.Named;
import jakarta.ws.rs.Consumes;
import jakarta.ws.rs.DELETE;
import jakarta.ws.rs.GET;
import jakarta.ws.rs.PUT;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.PathParam;
import java.io.Closeable;
import java.net.URI;
import java.util.List;
import java.util.Map;
import org.jclouds.Fallbacks;
import org.jclouds.azurecompute.arm.domain.Resource;
import org.jclouds.azurecompute.arm.domain.ResourceGroup;
import org.jclouds.azurecompute.arm.filters.ApiVersionFilter;
import org.jclouds.azurecompute.arm.functions.URIParser;
import org.jclouds.javax.annotation.Nullable;
import org.jclouds.oauth.v2.filters.OAuthFilter;
import org.jclouds.rest.annotations.Fallback;
import org.jclouds.rest.annotations.MapBinder;
import org.jclouds.rest.annotations.PATCH;
import org.jclouds.rest.annotations.PayloadParam;
import org.jclouds.rest.annotations.RequestFilters;
import org.jclouds.rest.annotations.ResponseParser;
import org.jclouds.rest.annotations.SelectJson;
import org.jclouds.rest.binders.BindToJsonPayload;

@Path(value="/resourcegroups")
@RequestFilters(value={OAuthFilter.class, ApiVersionFilter.class})
@Consumes(value={"application/json"})
public interface ResourceGroupApi
extends Closeable {
    @Named(value="resourcegroup:list")
    @SelectJson(value={"value"})
    @GET
    @Fallback(value=Fallbacks.EmptyListOnNotFoundOr404.class)
    public List<ResourceGroup> list();

    @Named(value="resourcegroup:create")
    @PUT
    @Path(value="/{name}")
    @MapBinder(value=BindToJsonPayload.class)
    public ResourceGroup create(@PathParam(value="name") String var1, @PayloadParam(value="location") String var2, @Nullable @PayloadParam(value="tags") Map<String, String> var3);

    @Named(value="resourcegroup:get")
    @GET
    @Path(value="/{name}")
    @Fallback(value=Fallbacks.NullOnNotFoundOr404.class)
    @Nullable
    public ResourceGroup get(@PathParam(value="name") String var1);

    @Named(value="resourcegroup:resources")
    @GET
    @Path(value="/{name}/resources")
    @SelectJson(value={"value"})
    @Fallback(value=Fallbacks.EmptyListOnNotFoundOr404.class)
    public List<Resource> resources(@PathParam(value="name") String var1);

    @Named(value="resourcegroup:update")
    @PATCH
    @Path(value="/{name}")
    @MapBinder(value=BindToJsonPayload.class)
    public ResourceGroup update(@PathParam(value="name") String var1, @Nullable @PayloadParam(value="tags") Map<String, String> var2);

    @Named(value="resourcegroup:delete")
    @DELETE
    @ResponseParser(value=URIParser.class)
    @Path(value="/{name}")
    @Fallback(value=Fallbacks.NullOnNotFoundOr404.class)
    public URI delete(@PathParam(value="name") String var1);
}

