/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.azurecompute.arm.features;

import jakarta.inject.Named;
import jakarta.ws.rs.Consumes;
import jakarta.ws.rs.DELETE;
import jakarta.ws.rs.GET;
import jakarta.ws.rs.PUT;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.PathParam;
import java.util.List;
import java.util.Map;
import org.jclouds.Fallbacks;
import org.jclouds.azurecompute.arm.domain.publicipaddress.PublicIPAddress;
import org.jclouds.azurecompute.arm.domain.publicipaddress.PublicIPAddressProperties;
import org.jclouds.azurecompute.arm.filters.ApiVersionFilter;
import org.jclouds.azurecompute.arm.functions.FalseOn204;
import org.jclouds.javax.annotation.Nullable;
import org.jclouds.oauth.v2.filters.OAuthFilter;
import org.jclouds.rest.annotations.Fallback;
import org.jclouds.rest.annotations.MapBinder;
import org.jclouds.rest.annotations.PayloadParam;
import org.jclouds.rest.annotations.RequestFilters;
import org.jclouds.rest.annotations.ResponseParser;
import org.jclouds.rest.annotations.SelectJson;
import org.jclouds.rest.binders.BindToJsonPayload;

@RequestFilters(value={OAuthFilter.class, ApiVersionFilter.class})
@Consumes(value={"application/json"})
public interface PublicIPAddressApi {
    @Named(value="publicipaddress:list")
    @Path(value="/resourcegroups/{resourcegroup}/providers/Microsoft.Network/publicIPAddresses")
    @SelectJson(value={"value"})
    @GET
    @Fallback(value=Fallbacks.EmptyListOnNotFoundOr404.class)
    public List<PublicIPAddress> list();

    @Named(value="publicipaddress:list_all")
    @Path(value="/providers/Microsoft.Network/publicIPAddresses")
    @SelectJson(value={"value"})
    @GET
    @Fallback(value=Fallbacks.EmptyListOnNotFoundOr404.class)
    public List<PublicIPAddress> listAllInSubscription();

    @Named(value="publicipaddress:create_or_update")
    @Path(value="/resourcegroups/{resourcegroup}/providers/Microsoft.Network/publicIPAddresses/{publicipaddressname}")
    @MapBinder(value=BindToJsonPayload.class)
    @PUT
    public PublicIPAddress createOrUpdate(@PathParam(value="publicipaddressname") String var1, @PayloadParam(value="location") String var2, @Nullable @PayloadParam(value="tags") Map<String, String> var3, @Nullable @PayloadParam(value="sku") PublicIPAddress.SKU var4, @PayloadParam(value="properties") PublicIPAddressProperties var5);

    @Named(value="publicipaddress:get")
    @Path(value="/resourcegroups/{resourcegroup}/providers/Microsoft.Network/publicIPAddresses/{publicipaddressname}")
    @GET
    @Fallback(value=Fallbacks.NullOnNotFoundOr404.class)
    public PublicIPAddress get(@PathParam(value="publicipaddressname") String var1);

    @Named(value="publicipaddress:delete")
    @Path(value="/resourcegroups/{resourcegroup}/providers/Microsoft.Network/publicIPAddresses/{publicipaddressname}")
    @DELETE
    @ResponseParser(value=FalseOn204.class)
    public boolean delete(@PathParam(value="publicipaddressname") String var1);
}

