/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.azurecompute.arm.features;

import jakarta.inject.Named;
import jakarta.ws.rs.Consumes;
import jakarta.ws.rs.DELETE;
import jakarta.ws.rs.GET;
import jakarta.ws.rs.PUT;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.PathParam;
import java.net.URI;
import java.util.List;
import java.util.Map;
import org.jclouds.Fallbacks;
import org.jclouds.azurecompute.arm.domain.loadbalancer.LoadBalancer;
import org.jclouds.azurecompute.arm.domain.loadbalancer.LoadBalancerProperties;
import org.jclouds.azurecompute.arm.filters.ApiVersionFilter;
import org.jclouds.azurecompute.arm.functions.URIParser;
import org.jclouds.javax.annotation.Nullable;
import org.jclouds.oauth.v2.filters.OAuthFilter;
import org.jclouds.rest.annotations.Fallback;
import org.jclouds.rest.annotations.MapBinder;
import org.jclouds.rest.annotations.PayloadParam;
import org.jclouds.rest.annotations.RequestFilters;
import org.jclouds.rest.annotations.ResponseParser;
import org.jclouds.rest.annotations.SelectJson;
import org.jclouds.rest.binders.BindToJsonPayload;

@RequestFilters(value={OAuthFilter.class, ApiVersionFilter.class})
@Consumes(value={"application/json"})
public interface LoadBalancerApi {
    @Named(value="loadbalancer:list")
    @GET
    @Path(value="/resourcegroups/{resourcegroup}/providers/Microsoft.Network/loadBalancers")
    @SelectJson(value={"value"})
    @Fallback(value=Fallbacks.EmptyListOnNotFoundOr404.class)
    public List<LoadBalancer> list();

    @Named(value="loadbalancer:listall")
    @GET
    @Path(value="/providers/Microsoft.Network/loadBalancers")
    @SelectJson(value={"value"})
    @Fallback(value=Fallbacks.EmptyListOnNotFoundOr404.class)
    public List<LoadBalancer> listAll();

    @Named(value="loadbalancer:get")
    @Path(value="/resourcegroups/{resourcegroup}/providers/Microsoft.Network/loadBalancers/{loadbalancername}")
    @GET
    @Fallback(value=Fallbacks.NullOnNotFoundOr404.class)
    public LoadBalancer get(@PathParam(value="loadbalancername") String var1);

    @Named(value="loadbalancer:createOrUpdate")
    @Path(value="/resourcegroups/{resourcegroup}/providers/Microsoft.Network/loadBalancers/{loadbalancername}")
    @PUT
    @MapBinder(value=BindToJsonPayload.class)
    public LoadBalancer createOrUpdate(@PathParam(value="loadbalancername") String var1, @PayloadParam(value="location") String var2, @Nullable @PayloadParam(value="tags") Map<String, String> var3, @Nullable @PayloadParam(value="sku") LoadBalancer.SKU var4, @PayloadParam(value="properties") LoadBalancerProperties var5);

    @Named(value="loadbalancer:delete")
    @Path(value="/resourcegroups/{resourcegroup}/providers/Microsoft.Network/loadBalancers/{loadbalancername}")
    @DELETE
    @ResponseParser(value=URIParser.class)
    @Fallback(value=Fallbacks.NullOnNotFoundOr404.class)
    public URI delete(@PathParam(value="loadbalancername") String var1);
}

