/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.azurecompute.arm.features;

import jakarta.inject.Named;
import jakarta.ws.rs.Consumes;
import jakarta.ws.rs.DELETE;
import jakarta.ws.rs.GET;
import jakarta.ws.rs.POST;
import jakarta.ws.rs.PUT;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.PathParam;
import jakarta.ws.rs.Produces;
import java.net.URI;
import java.util.List;
import org.jclouds.Fallbacks;
import org.jclouds.azurecompute.arm.domain.Deployment;
import org.jclouds.azurecompute.arm.filters.ApiVersionFilter;
import org.jclouds.azurecompute.arm.functions.URIParser;
import org.jclouds.oauth.v2.filters.OAuthFilter;
import org.jclouds.rest.annotations.Fallback;
import org.jclouds.rest.annotations.Payload;
import org.jclouds.rest.annotations.PayloadParam;
import org.jclouds.rest.annotations.RequestFilters;
import org.jclouds.rest.annotations.ResponseParser;
import org.jclouds.rest.annotations.SelectJson;

@Path(value="/resourcegroups/{resourcegroup}/providers/microsoft.resources/deployments")
@RequestFilters(value={OAuthFilter.class, ApiVersionFilter.class})
@Consumes(value={"application/json"})
public interface DeploymentApi {
    @Named(value="deployment:create")
    @Path(value="/{deploymentname}")
    @Payload(value="{template}")
    @PUT
    @Produces(value={"application/json"})
    public Deployment create(@PathParam(value="deploymentname") String var1, @PayloadParam(value="template") String var2);

    @Named(value="deployment:get")
    @Path(value="/{deploymentname}")
    @GET
    @Fallback(value=Fallbacks.NullOnNotFoundOr404.class)
    public Deployment get(@PathParam(value="deploymentname") String var1);

    @Named(value="deployment:validate")
    @Path(value="/{deploymentname}/validate")
    @Payload(value="{template}")
    @POST
    @Produces(value={"application/json"})
    public Deployment validate(@PathParam(value="deploymentname") String var1, @PayloadParam(value="template") String var2);

    @Named(value="deployment:list")
    @GET
    @SelectJson(value={"value"})
    @Fallback(value=Fallbacks.EmptyListOnNotFoundOr404.class)
    public List<Deployment> list();

    @Named(value="deployment:delete")
    @DELETE
    @ResponseParser(value=URIParser.class)
    @Path(value="/{deploymentname}")
    @Fallback(value=Fallbacks.NullOnNotFoundOr404.class)
    public URI delete(@PathParam(value="deploymentname") String var1);
}

