/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.azurecompute.arm.features;

import jakarta.inject.Named;
import jakarta.ws.rs.Consumes;
import jakarta.ws.rs.DELETE;
import jakarta.ws.rs.GET;
import jakarta.ws.rs.PUT;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.PathParam;
import java.io.Closeable;
import java.net.URI;
import java.util.List;
import java.util.Map;
import org.jclouds.Fallbacks;
import org.jclouds.azurecompute.arm.domain.AvailabilitySet;
import org.jclouds.azurecompute.arm.filters.ApiVersionFilter;
import org.jclouds.azurecompute.arm.functions.URIParser;
import org.jclouds.javax.annotation.Nullable;
import org.jclouds.oauth.v2.filters.OAuthFilter;
import org.jclouds.rest.annotations.Fallback;
import org.jclouds.rest.annotations.MapBinder;
import org.jclouds.rest.annotations.PayloadParam;
import org.jclouds.rest.annotations.RequestFilters;
import org.jclouds.rest.annotations.ResponseParser;
import org.jclouds.rest.annotations.SelectJson;
import org.jclouds.rest.binders.BindToJsonPayload;

@Path(value="/resourcegroups/{resourcegroup}/providers/Microsoft.Compute/availabilitySets")
@RequestFilters(value={OAuthFilter.class, ApiVersionFilter.class})
@Consumes(value={"application/json"})
public interface AvailabilitySetApi
extends Closeable {
    @Named(value="availabilityset:list")
    @GET
    @SelectJson(value={"value"})
    @Fallback(value=Fallbacks.EmptyListOnNotFoundOr404.class)
    public List<AvailabilitySet> list();

    @Named(value="availabilityset:get")
    @Path(value="/{name}")
    @GET
    @Fallback(value=Fallbacks.NullOnNotFoundOr404.class)
    public AvailabilitySet get(@PathParam(value="name") String var1);

    @Named(value="availabilityset:createOrUpdate")
    @MapBinder(value=BindToJsonPayload.class)
    @Path(value="/{name}")
    @PUT
    public AvailabilitySet createOrUpdate(@PathParam(value="name") String var1, @Nullable @PayloadParam(value="sku") AvailabilitySet.SKU var2, @PayloadParam(value="location") String var3, @Nullable @PayloadParam(value="tags") Map<String, String> var4, @PayloadParam(value="properties") AvailabilitySet.AvailabilitySetProperties var5);

    @Named(value="availabilityset:delete")
    @Path(value="/{name}")
    @DELETE
    @ResponseParser(value=URIParser.class)
    @Fallback(value=Fallbacks.NullOnNotFoundOr404.class)
    public URI delete(@PathParam(value="name") String var1);
}

