/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.azurecompute.arm.domain.loadbalancer;

import com.google.auto.value.AutoValue;
import com.google.common.collect.ImmutableList;
import java.util.List;
import org.jclouds.azurecompute.arm.domain.BackendAddressPool;
import org.jclouds.azurecompute.arm.domain.FrontendIPConfigurations;
import org.jclouds.azurecompute.arm.domain.InboundNatRule;
import org.jclouds.azurecompute.arm.domain.Probe;
import org.jclouds.azurecompute.arm.domain.Provisionable;
import org.jclouds.azurecompute.arm.domain.loadbalancer.AutoValue_LoadBalancerProperties;
import org.jclouds.azurecompute.arm.domain.loadbalancer.LoadBalancingRule;
import org.jclouds.javax.annotation.Nullable;
import org.jclouds.json.SerializedNames;

@AutoValue
public abstract class LoadBalancerProperties
implements Provisionable {
    @Nullable
    public abstract List<FrontendIPConfigurations> frontendIPConfigurations();

    @Nullable
    public abstract List<BackendAddressPool> backendAddressPools();

    @Nullable
    public abstract List<LoadBalancingRule> loadBalancingRules();

    @Nullable
    public abstract List<Probe> probes();

    @Nullable
    public abstract List<InboundNatRule> inboundNatRules();

    @Nullable
    public abstract String resourceGuid();

    @Override
    @Nullable
    public abstract String provisioningState();

    @SerializedNames(value={"frontendIPConfigurations", "backendAddressPools", "loadBalancingRules", "probes", "inboundNatRules", "resourceGuid", "provisioningState"})
    public static LoadBalancerProperties create(List<FrontendIPConfigurations> frontendIPConfigurations, List<BackendAddressPool> backendAddressPools, List<LoadBalancingRule> loadBalancingRules, List<Probe> probes, List<InboundNatRule> inboundNatRules, String resourceGuid, String provisioningState) {
        return LoadBalancerProperties.builder().frontendIPConfigurations(frontendIPConfigurations).backendAddressPools((List<BackendAddressPool>)(backendAddressPools == null ? null : ImmutableList.copyOf(backendAddressPools))).loadBalancingRules((List<LoadBalancingRule>)(loadBalancingRules == null ? null : ImmutableList.copyOf(loadBalancingRules))).probes((List<Probe>)(probes == null ? null : ImmutableList.copyOf(probes))).inboundNatRules((List<InboundNatRule>)(inboundNatRules == null ? null : ImmutableList.copyOf(inboundNatRules))).resourceGuid(resourceGuid).provisioningState(provisioningState).build();
    }

    public abstract Builder toBuilder();

    public static Builder builder() {
        return new AutoValue_LoadBalancerProperties.Builder();
    }

    @AutoValue.Builder
    public static abstract class Builder {
        public abstract Builder frontendIPConfigurations(List<FrontendIPConfigurations> var1);

        public abstract Builder backendAddressPools(List<BackendAddressPool> var1);

        public abstract Builder loadBalancingRules(List<LoadBalancingRule> var1);

        public abstract Builder probes(List<Probe> var1);

        public abstract Builder inboundNatRules(List<InboundNatRule> var1);

        public abstract Builder resourceGuid(String var1);

        public abstract Builder provisioningState(String var1);

        abstract List<FrontendIPConfigurations> frontendIPConfigurations();

        abstract List<BackendAddressPool> backendAddressPools();

        abstract List<LoadBalancingRule> loadBalancingRules();

        abstract List<Probe> probes();

        abstract List<InboundNatRule> inboundNatRules();

        abstract LoadBalancerProperties autoBuild();

        public LoadBalancerProperties build() {
            this.frontendIPConfigurations((List<FrontendIPConfigurations>)(this.frontendIPConfigurations() != null ? ImmutableList.copyOf(this.frontendIPConfigurations()) : null));
            this.backendAddressPools((List<BackendAddressPool>)(this.backendAddressPools() != null ? ImmutableList.copyOf(this.backendAddressPools()) : null));
            this.loadBalancingRules((List<LoadBalancingRule>)(this.loadBalancingRules() != null ? ImmutableList.copyOf(this.loadBalancingRules()) : null));
            this.probes((List<Probe>)(this.probes() != null ? ImmutableList.copyOf(this.probes()) : null));
            this.inboundNatRules((List<InboundNatRule>)(this.inboundNatRules() != null ? ImmutableList.copyOf(this.inboundNatRules()) : null));
            return this.autoBuild();
        }
    }
}

