/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.azurecompute.arm.domain;

import com.google.auto.value.AutoValue;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import java.util.List;
import java.util.Map;
import org.jclouds.azurecompute.arm.domain.AddressSpace;
import org.jclouds.azurecompute.arm.domain.AutoValue_VirtualNetwork;
import org.jclouds.azurecompute.arm.domain.AutoValue_VirtualNetwork_VirtualNetworkProperties;
import org.jclouds.azurecompute.arm.domain.Provisionable;
import org.jclouds.azurecompute.arm.domain.Subnet;
import org.jclouds.javax.annotation.Nullable;
import org.jclouds.json.SerializedNames;

@AutoValue
public abstract class VirtualNetwork {
    @Nullable
    public abstract String name();

    @Nullable
    public abstract String id();

    @Nullable
    public abstract String etag();

    public abstract String location();

    public abstract VirtualNetworkProperties properties();

    @Nullable
    public abstract Map<String, String> tags();

    @SerializedNames(value={"name", "id", "etag", "location", "properties", "tags"})
    public static VirtualNetwork create(String name, String id, String etag, String location, VirtualNetworkProperties properties, Map<String, String> tags) {
        return new AutoValue_VirtualNetwork(name, id, etag, location, properties, (Map<String, String>)(tags == null ? null : ImmutableMap.copyOf(tags)));
    }

    @AutoValue
    public static abstract class VirtualNetworkProperties
    implements Provisionable {
        @Override
        @Nullable
        public abstract String provisioningState();

        @Nullable
        public abstract String resourceGuid();

        public abstract AddressSpace addressSpace();

        @Nullable
        public abstract List<Subnet> subnets();

        @SerializedNames(value={"provisioningState", "resourceGuid", "addressSpace", "subnets"})
        public static VirtualNetworkProperties create(String provisioningState, String resourceGuid, AddressSpace addressSpace, List<Subnet> subnets) {
            return VirtualNetworkProperties.builder().provisioningState(provisioningState).resourceGuid(resourceGuid).addressSpace(addressSpace).subnets((List<Subnet>)(subnets != null ? ImmutableList.copyOf(subnets) : null)).build();
        }

        public abstract Builder toBuilder();

        public static Builder builder() {
            return new AutoValue_VirtualNetwork_VirtualNetworkProperties.Builder();
        }

        @AutoValue.Builder
        public static abstract class Builder {
            public abstract Builder provisioningState(String var1);

            public abstract Builder resourceGuid(String var1);

            public abstract Builder addressSpace(AddressSpace var1);

            public abstract Builder subnets(List<Subnet> var1);

            abstract List<Subnet> subnets();

            abstract VirtualNetworkProperties autoBuild();

            public VirtualNetworkProperties build() {
                this.subnets((List<Subnet>)(this.subnets() != null ? ImmutableList.copyOf(this.subnets()) : null));
                return this.autoBuild();
            }
        }
    }
}

