/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.azurecompute.arm.domain;

import com.google.auto.value.AutoValue;
import org.jclouds.azurecompute.arm.domain.AutoValue_VirtualMachineProperties;
import org.jclouds.azurecompute.arm.domain.DiagnosticsProfile;
import org.jclouds.azurecompute.arm.domain.HardwareProfile;
import org.jclouds.azurecompute.arm.domain.IdReference;
import org.jclouds.azurecompute.arm.domain.NetworkProfile;
import org.jclouds.azurecompute.arm.domain.OSProfile;
import org.jclouds.azurecompute.arm.domain.StorageProfile;
import org.jclouds.azurecompute.arm.util.GetEnumValue;
import org.jclouds.javax.annotation.Nullable;
import org.jclouds.json.SerializedNames;

@AutoValue
public abstract class VirtualMachineProperties {
    @Nullable
    public abstract String vmId();

    @Nullable
    public abstract String licenseType();

    @Nullable
    public abstract IdReference availabilitySet();

    @Nullable
    public abstract HardwareProfile hardwareProfile();

    @Nullable
    public abstract StorageProfile storageProfile();

    @Nullable
    public abstract OSProfile osProfile();

    @Nullable
    public abstract NetworkProfile networkProfile();

    @Nullable
    public abstract DiagnosticsProfile diagnosticsProfile();

    @Nullable
    public abstract ProvisioningState provisioningState();

    @SerializedNames(value={"vmId", "licenseType", "availabilitySet", "hardwareProfile", "storageProfile", "osProfile", "networkProfile", "diagnosticsProfile", "provisioningState"})
    public static VirtualMachineProperties create(String vmId, String licenseType, IdReference availabilitySet, HardwareProfile hardwareProfile, StorageProfile storageProfile, OSProfile osProfile, NetworkProfile networkProfile, DiagnosticsProfile diagnosticsProfile, ProvisioningState provisioningState) {
        return VirtualMachineProperties.builder().vmId(vmId).licenseType(licenseType).availabilitySet(availabilitySet).hardwareProfile(hardwareProfile).storageProfile(storageProfile).osProfile(osProfile).networkProfile(networkProfile).diagnosticsProfile(diagnosticsProfile).provisioningState(provisioningState).build();
    }

    public abstract Builder toBuilder();

    public static Builder builder() {
        return new AutoValue_VirtualMachineProperties.Builder();
    }

    @AutoValue.Builder
    public static abstract class Builder {
        public abstract Builder vmId(String var1);

        public abstract Builder licenseType(String var1);

        public abstract Builder availabilitySet(IdReference var1);

        public abstract Builder hardwareProfile(HardwareProfile var1);

        public abstract Builder storageProfile(StorageProfile var1);

        public abstract Builder osProfile(OSProfile var1);

        public abstract Builder networkProfile(NetworkProfile var1);

        public abstract Builder diagnosticsProfile(DiagnosticsProfile var1);

        public abstract Builder provisioningState(ProvisioningState var1);

        public abstract VirtualMachineProperties build();
    }

    public static enum ProvisioningState {
        ACCEPTED,
        CREATING,
        READY,
        CANCELED,
        FAILED,
        DELETED,
        SUCCEEDED,
        RUNNING,
        UPDATING,
        UNRECOGNIZED;


        public static ProvisioningState fromValue(String text) {
            return (ProvisioningState)GetEnumValue.fromValueOrDefault(text, UNRECOGNIZED);
        }
    }
}

