/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.azurecompute.arm.domain;

import com.google.auto.value.AutoValue;
import com.google.common.collect.ImmutableList;
import java.net.URI;
import java.util.List;
import org.jclouds.azurecompute.arm.domain.AutoValue_VaultProperties;
import org.jclouds.azurecompute.arm.domain.AutoValue_VaultProperties_AccessPolicyEntry;
import org.jclouds.azurecompute.arm.domain.AutoValue_VaultProperties_Permissions;
import org.jclouds.azurecompute.arm.domain.SKU;
import org.jclouds.javax.annotation.Nullable;
import org.jclouds.json.SerializedNames;

@AutoValue
public abstract class VaultProperties {
    @Nullable
    public abstract String tenantId();

    @Nullable
    public abstract URI vaultUri();

    @Nullable
    public abstract Boolean enabledForDeployment();

    @Nullable
    public abstract Boolean enabledForTemplateDeployment();

    @Nullable
    public abstract Boolean enableSoftDelete();

    @Nullable
    public abstract String createMode();

    @Nullable
    public abstract SKU sku();

    @Nullable
    public abstract List<AccessPolicyEntry> accessPolicies();

    @SerializedNames(value={"tenantId", "vaultUri", "enabledForDeployment", "enabledForTemplateDeployment", "enableSoftDelete", "createMode", "sku", "accessPolicies"})
    public static VaultProperties create(String tenantId, URI vaultUri, Boolean enabledForDeployment, Boolean enabledForTemplateDeployment, Boolean enableSoftDelete, String createMode, SKU sku, List<AccessPolicyEntry> accessPolicies) {
        return VaultProperties.builder().tenantId(tenantId).vaultUri(vaultUri).enabledForDeployment(enabledForDeployment).enabledForTemplateDeployment(enabledForTemplateDeployment).enableSoftDelete(enableSoftDelete).createMode(createMode).sku(sku).accessPolicies(accessPolicies).build();
    }

    public abstract Builder toBuilder();

    public static Builder builder() {
        return new AutoValue_VaultProperties.Builder();
    }

    @AutoValue.Builder
    public static abstract class Builder {
        public abstract Builder tenantId(String var1);

        public abstract Builder vaultUri(URI var1);

        public abstract Builder enabledForDeployment(Boolean var1);

        public abstract Builder enabledForTemplateDeployment(Boolean var1);

        public abstract Builder enableSoftDelete(Boolean var1);

        public abstract Builder createMode(String var1);

        public abstract Builder sku(SKU var1);

        public abstract Builder accessPolicies(List<AccessPolicyEntry> var1);

        abstract List<AccessPolicyEntry> accessPolicies();

        abstract VaultProperties autoBuild();

        public VaultProperties build() {
            return this.accessPolicies((List<AccessPolicyEntry>)(this.accessPolicies() != null ? ImmutableList.copyOf(this.accessPolicies()) : ImmutableList.of())).autoBuild();
        }
    }

    @AutoValue
    public static abstract class AccessPolicyEntry {
        @Nullable
        public abstract String applicationId();

        public abstract String objectId();

        public abstract String tenantId();

        @Nullable
        public abstract Permissions permissions();

        @SerializedNames(value={"applicationId", "objectId", "tenantId", "permissions"})
        public static AccessPolicyEntry create(String applicationId, String objectId, String tenantId, Permissions permissions) {
            return new AutoValue_VaultProperties_AccessPolicyEntry(applicationId, objectId, tenantId, permissions);
        }

        AccessPolicyEntry() {
        }
    }

    @AutoValue
    public static abstract class Permissions {
        public abstract List<String> certificates();

        public abstract List<String> keys();

        public abstract List<String> secrets();

        public abstract List<String> storage();

        @SerializedNames(value={"certificates", "keys", "secrets", "storage"})
        public static Permissions create(List<String> certificates, List<String> keys, List<String> secrets, List<String> storage) {
            return new AutoValue_VaultProperties_Permissions((List<String>)(certificates != null ? ImmutableList.copyOf(certificates) : ImmutableList.of()), (List<String>)(keys != null ? ImmutableList.copyOf(keys) : ImmutableList.of()), (List<String>)(secrets != null ? ImmutableList.copyOf(secrets) : ImmutableList.of()), (List<String>)(storage != null ? ImmutableList.copyOf(storage) : ImmutableList.of()));
        }

        Permissions() {
        }
    }
}

