/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.azurecompute.arm.domain;

import com.google.auto.value.AutoValue;
import com.google.common.base.Preconditions;
import org.jclouds.azurecompute.arm.domain.AutoValue_VMImage;
import org.jclouds.azurecompute.arm.domain.Version;
import org.jclouds.azurecompute.arm.util.VMImages;
import org.jclouds.javax.annotation.Nullable;

@AutoValue
public abstract class VMImage {
    @Nullable
    public abstract String publisher();

    @Nullable
    public abstract String offer();

    @Nullable
    public abstract String sku();

    @Nullable
    public abstract String version();

    @Nullable
    public abstract String location();

    @Nullable
    public abstract String group();

    @Nullable
    public abstract String storage();

    @Nullable
    public abstract String vhd1();

    @Nullable
    public abstract String vhd2();

    @Nullable
    public abstract String name();

    public abstract boolean custom();

    @Nullable
    public abstract String customImageId();

    @Nullable
    public abstract String resourceGroup();

    @Nullable
    public abstract Version.VersionProperties versionProperties();

    private static Builder builder() {
        return new AutoValue_VMImage.Builder();
    }

    public static Builder azureImage() {
        return VMImage.builder().custom(false);
    }

    public static Builder customImage() {
        return VMImage.builder().custom(true);
    }

    VMImage() {
    }

    public abstract Builder toBuilder();

    public String encodeFieldsToUniqueId() {
        return String.format("%s/%s/%s/%s", this.location(), this.publisher(), this.offer(), this.sku());
    }

    public String encodeFieldsToUniqueIdCustom() {
        return String.format("%s/%s/%s", this.resourceGroup(), this.location(), this.name());
    }

    public static VMImage decodeFieldsFromUniqueId(String id) {
        String[] fields = ((String)Preconditions.checkNotNull((Object)id, (Object)"id")).split("/");
        VMImage vmImage = VMImages.isCustom(id) ? VMImage.customImage().resourceGroup(fields[0]).location(fields[1]).name(fields[2]).build() : VMImage.azureImage().location(fields[0]).publisher(fields[1]).offer(fields[2]).sku(fields[3]).build();
        return vmImage;
    }

    @AutoValue.Builder
    public static abstract class Builder {
        public abstract Builder customImageId(String var1);

        public abstract Builder resourceGroup(String var1);

        public abstract Builder publisher(String var1);

        public abstract Builder offer(String var1);

        public abstract Builder sku(String var1);

        public abstract Builder version(String var1);

        public abstract Builder location(String var1);

        public abstract Builder group(String var1);

        public abstract Builder storage(String var1);

        public abstract Builder vhd1(String var1);

        public abstract Builder vhd2(String var1);

        public abstract Builder name(String var1);

        public abstract Builder custom(boolean var1);

        public abstract Builder versionProperties(Version.VersionProperties var1);

        public abstract VMImage build();
    }
}

