/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.azurecompute.arm.domain;

import com.google.auto.value.AutoValue;
import org.jclouds.azurecompute.arm.domain.AutoValue_OSDisk;
import org.jclouds.azurecompute.arm.domain.ManagedDiskParameters;
import org.jclouds.azurecompute.arm.domain.StorageAccountType;
import org.jclouds.azurecompute.arm.domain.VHD;
import org.jclouds.javax.annotation.Nullable;
import org.jclouds.json.SerializedNames;

@AutoValue
public abstract class OSDisk {
    @Nullable
    public abstract String osType();

    @Nullable
    public abstract String name();

    @Nullable
    public abstract VHD vhd();

    @Nullable
    public abstract String caching();

    @Nullable
    public abstract String createOption();

    @Nullable
    public abstract VHD image();

    @Nullable
    public abstract ManagedDiskParameters managedDiskParameters();

    @Nullable
    public abstract StorageAccountType storageAccountType();

    @SerializedNames(value={"osType", "name", "vhd", "caching", "createOption", "image", "managedDisk", "storageAccountType"})
    public static OSDisk create(String osType, String name, VHD vhd, String caching, String createOption, VHD image, ManagedDiskParameters managedDiskParamenters, String storageAccountType) {
        return OSDisk.builder().osType(osType).name(name).vhd(vhd).caching(caching).createOption(createOption).image(image).managedDiskParameters(managedDiskParamenters).storageAccountType(StorageAccountType.fromString(storageAccountType)).build();
    }

    public abstract Builder toBuilder();

    public static Builder builder() {
        return new AutoValue_OSDisk.Builder();
    }

    @AutoValue.Builder
    public static abstract class Builder {
        public abstract Builder osType(String var1);

        public abstract Builder name(String var1);

        public abstract Builder caching(String var1);

        public abstract Builder createOption(String var1);

        public abstract Builder vhd(VHD var1);

        public abstract Builder image(VHD var1);

        public abstract Builder managedDiskParameters(ManagedDiskParameters var1);

        public abstract Builder storageAccountType(StorageAccountType var1);

        public abstract OSDisk build();
    }
}

