/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.azurecompute.arm.domain;

import com.google.auto.value.AutoValue;
import com.google.common.collect.ImmutableList;
import java.util.List;
import org.jclouds.azurecompute.arm.domain.AutoValue_IpConfigurationProperties;
import org.jclouds.azurecompute.arm.domain.IdReference;
import org.jclouds.azurecompute.arm.domain.Provisionable;
import org.jclouds.javax.annotation.Nullable;
import org.jclouds.json.SerializedNames;

@AutoValue
public abstract class IpConfigurationProperties
implements Provisionable {
    @Override
    @Nullable
    public abstract String provisioningState();

    @Nullable
    public abstract String privateIPAddress();

    @Nullable
    public abstract String privateIPAllocationMethod();

    @Nullable
    public abstract IdReference subnet();

    @Nullable
    public abstract IdReference publicIPAddress();

    @Nullable
    public abstract List<IdReference> loadBalancerBackendAddressPools();

    @Nullable
    public abstract List<IdReference> loadBalancerInboundNatRules();

    @Nullable
    public abstract Boolean primary();

    @SerializedNames(value={"provisioningState", "privateIPAddress", "privateIPAllocationMethod", "subnet", "publicIPAddress", "loadBalancerBackendAddressPools", "loadBalancerInboundNatRules", "primary"})
    public static IpConfigurationProperties create(String provisioningState, String privateIPAddress, String privateIPAllocationMethod, IdReference subnet, IdReference publicIPAddress, List<IdReference> loadBalancerBackendAddressPools, List<IdReference> loadBalancerInboundNatRules, Boolean primary) {
        return IpConfigurationProperties.builder().provisioningState(provisioningState).privateIPAddress(privateIPAddress).privateIPAllocationMethod(privateIPAllocationMethod).subnet(subnet).publicIPAddress(publicIPAddress).loadBalancerBackendAddressPools(loadBalancerBackendAddressPools).loadBalancerInboundNatRules(loadBalancerInboundNatRules).primary(primary).build();
    }

    public abstract Builder toBuilder();

    public static Builder builder() {
        return new AutoValue_IpConfigurationProperties.Builder();
    }

    @AutoValue.Builder
    public static abstract class Builder {
        public abstract Builder provisioningState(String var1);

        public abstract Builder privateIPAddress(String var1);

        public abstract Builder privateIPAllocationMethod(String var1);

        public abstract Builder subnet(IdReference var1);

        public abstract Builder publicIPAddress(IdReference var1);

        public abstract Builder loadBalancerBackendAddressPools(List<IdReference> var1);

        public abstract Builder loadBalancerInboundNatRules(List<IdReference> var1);

        public abstract Builder primary(Boolean var1);

        abstract List<IdReference> loadBalancerBackendAddressPools();

        abstract List<IdReference> loadBalancerInboundNatRules();

        abstract IpConfigurationProperties autoBuild();

        public IpConfigurationProperties build() {
            this.loadBalancerBackendAddressPools((List<IdReference>)(this.loadBalancerBackendAddressPools() != null ? ImmutableList.copyOf(this.loadBalancerBackendAddressPools()) : null));
            this.loadBalancerInboundNatRules((List<IdReference>)(this.loadBalancerInboundNatRules() != null ? ImmutableList.copyOf(this.loadBalancerInboundNatRules()) : null));
            return this.autoBuild();
        }
    }
}

