/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.azurecompute.arm.domain;

import com.google.auto.value.AutoValue;
import org.jclouds.azurecompute.arm.domain.AutoValue_ImageReference;
import org.jclouds.azurecompute.arm.domain.IdReference;
import org.jclouds.azurecompute.arm.domain.VMImage;
import org.jclouds.javax.annotation.Nullable;
import org.jclouds.json.SerializedNames;

@AutoValue
public abstract class ImageReference {
    @Nullable
    public abstract String customImageId();

    @Nullable
    public abstract String publisher();

    @Nullable
    public abstract String offer();

    @Nullable
    public abstract String sku();

    @Nullable
    public abstract String version();

    ImageReference() {
    }

    @SerializedNames(value={"id", "publisher", "offer", "sku", "version"})
    public static ImageReference create(String id, String publisher, String offer, String sku, String version) {
        return ImageReference.builder().customImageId(id).publisher(publisher).offer(offer).sku(sku).version(version).build();
    }

    public abstract Builder toBuilder();

    public static Builder builder() {
        return new AutoValue_ImageReference.Builder();
    }

    public String encodeFieldsToUniqueId(String location) {
        return VMImage.azureImage().location(location).publisher(this.publisher()).offer(this.offer()).sku(this.sku()).build().encodeFieldsToUniqueId();
    }

    public String encodeFieldsToUniqueIdCustom(String location) {
        return VMImage.customImage().resourceGroup(IdReference.extractResourceGroup(this.customImageId())).location(location).name(IdReference.extractName(this.customImageId())).build().encodeFieldsToUniqueIdCustom();
    }

    @AutoValue.Builder
    public static abstract class Builder {
        public abstract Builder customImageId(String var1);

        public abstract Builder publisher(String var1);

        public abstract Builder offer(String var1);

        public abstract Builder sku(String var1);

        public abstract Builder version(String var1);

        public abstract ImageReference build();
    }
}

