/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.azurecompute.arm.domain;

import com.google.auto.value.AutoValue;
import com.google.common.base.CaseFormat;
import org.jclouds.azurecompute.arm.domain.AutoValue_DataDisk;
import org.jclouds.azurecompute.arm.domain.ManagedDiskParameters;
import org.jclouds.azurecompute.arm.domain.Provisionable;
import org.jclouds.azurecompute.arm.domain.VHD;
import org.jclouds.azurecompute.arm.util.GetEnumValue;
import org.jclouds.javax.annotation.Nullable;
import org.jclouds.json.SerializedNames;

@AutoValue
public abstract class DataDisk
implements Provisionable {
    @Nullable
    public abstract String name();

    @Nullable
    public abstract String diskSizeGB();

    @Nullable
    public abstract Integer lun();

    @Nullable
    public abstract VHD vhd();

    @Nullable
    public abstract VHD image();

    public abstract DiskCreateOptionTypes createOption();

    @Nullable
    public abstract CachingTypes caching();

    @Nullable
    public abstract ManagedDiskParameters managedDiskParameters();

    @Override
    @Nullable
    public abstract String provisioningState();

    @SerializedNames(value={"name", "diskSizeGB", "lun", "vhd", "image", "createOption", "caching", "managedDisk", "provisioningState"})
    public static DataDisk create(String name, String diskSizeGB, Integer lun, VHD vhd, VHD image, String createOption, String caching, ManagedDiskParameters managedDiskParamenters, String provisioningState) {
        Builder builder = DataDisk.builder();
        if (caching != null) {
            builder.caching(CachingTypes.fromValue(caching));
        }
        return builder.name(name).diskSizeGB(diskSizeGB).lun(lun).vhd(vhd).image(image).createOption(DiskCreateOptionTypes.fromValue(createOption)).managedDiskParameters(managedDiskParamenters).provisioningState(provisioningState).build();
    }

    public abstract Builder toBuilder();

    public static Builder builder() {
        return new AutoValue_DataDisk.Builder();
    }

    @AutoValue.Builder
    public static abstract class Builder {
        public abstract Builder name(String var1);

        public abstract Builder diskSizeGB(String var1);

        public abstract Builder createOption(DiskCreateOptionTypes var1);

        public abstract Builder lun(Integer var1);

        public abstract Builder vhd(VHD var1);

        public abstract Builder image(VHD var1);

        public abstract Builder caching(CachingTypes var1);

        public abstract Builder managedDiskParameters(ManagedDiskParameters var1);

        public abstract Builder provisioningState(String var1);

        public abstract DataDisk build();
    }

    public static enum CachingTypes {
        NONE,
        READ_ONLY,
        READ_WRITE,
        UNRECOGNIZED;


        public static CachingTypes fromValue(String text) {
            for (CachingTypes type : CachingTypes.values()) {
                if (!type.toString().equals(text)) continue;
                return type;
            }
            return UNRECOGNIZED;
        }

        public String toString() {
            return CaseFormat.UPPER_UNDERSCORE.to(CaseFormat.UPPER_CAMEL, this.name());
        }
    }

    public static enum DiskCreateOptionTypes {
        FROM_IMAGE,
        EMPTY,
        ATTACH,
        UNRECOGNIZED;


        public static DiskCreateOptionTypes fromValue(String text) {
            return (DiskCreateOptionTypes)GetEnumValue.fromValueOrDefault(text, UNRECOGNIZED);
        }

        public String toString() {
            return CaseFormat.UPPER_UNDERSCORE.to(CaseFormat.UPPER_CAMEL, this.name());
        }
    }
}

