/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.azurecompute.arm.domain;

import com.google.auto.value.AutoValue;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import java.util.List;
import java.util.Map;
import org.jclouds.azurecompute.arm.domain.AutoValue_Certificate;
import org.jclouds.azurecompute.arm.domain.AutoValue_Certificate_AdministrationDetails;
import org.jclouds.azurecompute.arm.domain.AutoValue_Certificate_CertificateAttributes;
import org.jclouds.azurecompute.arm.domain.AutoValue_Certificate_CertificateBundle;
import org.jclouds.azurecompute.arm.domain.AutoValue_Certificate_CertificateError;
import org.jclouds.azurecompute.arm.domain.AutoValue_Certificate_CertificateIssuer;
import org.jclouds.azurecompute.arm.domain.AutoValue_Certificate_CertificateOperation;
import org.jclouds.azurecompute.arm.domain.AutoValue_Certificate_CertificatePolicy;
import org.jclouds.azurecompute.arm.domain.AutoValue_Certificate_Contact;
import org.jclouds.azurecompute.arm.domain.AutoValue_Certificate_Contacts;
import org.jclouds.azurecompute.arm.domain.AutoValue_Certificate_DeletedCertificate;
import org.jclouds.azurecompute.arm.domain.AutoValue_Certificate_DeletedCertificateBundle;
import org.jclouds.azurecompute.arm.domain.AutoValue_Certificate_IssuerAttributes;
import org.jclouds.azurecompute.arm.domain.AutoValue_Certificate_IssuerBundle;
import org.jclouds.azurecompute.arm.domain.AutoValue_Certificate_IssuerCredentials;
import org.jclouds.azurecompute.arm.domain.AutoValue_Certificate_IssuerParameters;
import org.jclouds.azurecompute.arm.domain.AutoValue_Certificate_KeyProperties;
import org.jclouds.azurecompute.arm.domain.AutoValue_Certificate_LifetimeAction;
import org.jclouds.azurecompute.arm.domain.AutoValue_Certificate_LifetimeActionAction;
import org.jclouds.azurecompute.arm.domain.AutoValue_Certificate_LifetimeActionTrigger;
import org.jclouds.azurecompute.arm.domain.AutoValue_Certificate_OrganizationDetails;
import org.jclouds.azurecompute.arm.domain.AutoValue_Certificate_SecretProperties;
import org.jclouds.azurecompute.arm.domain.AutoValue_Certificate_SubjectAlternativeNames;
import org.jclouds.azurecompute.arm.domain.AutoValue_Certificate_X509CertificateProperties;
import org.jclouds.javax.annotation.Nullable;
import org.jclouds.json.SerializedNames;

@AutoValue
public abstract class Certificate {
    @Nullable
    public abstract CertificateAttributes attributes();

    @Nullable
    public abstract String id();

    @Nullable
    public abstract Map<String, String> tags();

    @Nullable
    public abstract String thumbprint();

    @SerializedNames(value={"attributes", "id", "tags", "x5t"})
    public static Certificate create(CertificateAttributes attributes, String id, Map<String, String> tags, String thumbprint) {
        return new AutoValue_Certificate(attributes, id, (Map<String, String>)(tags != null ? ImmutableMap.copyOf(tags) : null), thumbprint);
    }

    Certificate() {
    }

    @AutoValue
    public static abstract class CertificateAttributes {
        @Nullable
        public abstract Integer created();

        public abstract boolean enabled();

        @Nullable
        public abstract Integer expiry();

        @Nullable
        public abstract Integer notBefore();

        @Nullable
        public abstract String recoveryLevel();

        @Nullable
        public abstract Integer updated();

        @SerializedNames(value={"created", "enabled", "exp", "nbf", "recoveryLevel", "updated"})
        public static CertificateAttributes create(Integer created, boolean enabled, Integer expiry, Integer notBefore, String recoveryLevel, Integer updated) {
            return new AutoValue_Certificate_CertificateAttributes(created, enabled, expiry, notBefore, recoveryLevel, updated);
        }
    }

    @AutoValue
    public static abstract class DeletedCertificate {
        @Nullable
        public abstract CertificateAttributes attributes();

        @Nullable
        public abstract Integer deletedDate();

        @Nullable
        public abstract String id();

        @Nullable
        public abstract String recoveryId();

        @Nullable
        public abstract Integer scheduledPurgeDate();

        @Nullable
        public abstract Map<String, String> tags();

        @Nullable
        public abstract String thumbprint();

        @SerializedNames(value={"attributes", "deletedDate", "id", "recoveryId", "scheduledPurgeDate", "tags", "x5t"})
        public static DeletedCertificate create(CertificateAttributes attributes, Integer deletedDate, String id, String recoveryId, Integer scheduledPurgeDate, Map<String, String> tags, String thumbprint) {
            return new AutoValue_Certificate_DeletedCertificate(attributes, deletedDate, id, recoveryId, scheduledPurgeDate, (Map<String, String>)(tags != null ? ImmutableMap.copyOf(tags) : null), thumbprint);
        }
    }

    @AutoValue
    public static abstract class DeletedCertificateBundle {
        @Nullable
        public abstract CertificateAttributes attributes();

        @Nullable
        public abstract String bytes();

        @Nullable
        public abstract Integer deletedDate();

        @Nullable
        public abstract String id();

        @Nullable
        public abstract String keyId();

        @Nullable
        public abstract String recoveryId();

        @Nullable
        public abstract Integer scheduledPurgeDate();

        @Nullable
        public abstract String secredId();

        @Nullable
        public abstract Map<String, String> tags();

        @Nullable
        public abstract String thumbprint();

        @SerializedNames(value={"attributes", "cer", "deletedDate", "id", "kid", "recoveryId", "scheduledPurgeDate", "sid", "tags", "x5t"})
        public static DeletedCertificateBundle create(CertificateAttributes attributes, String bytes, Integer deletedDate, String id, String keyId, String recoveryId, Integer scheduledPurgeDate, String secretId, Map<String, String> tags, String thumbprint) {
            return new AutoValue_Certificate_DeletedCertificateBundle(attributes, bytes, deletedDate, id, keyId, recoveryId, scheduledPurgeDate, secretId, (Map<String, String>)(tags != null ? ImmutableMap.copyOf(tags) : null), thumbprint);
        }
    }

    @AutoValue
    public static abstract class Contacts {
        public abstract List<Contact> contacts();

        @Nullable
        public abstract String id();

        @SerializedNames(value={"contacts", "id"})
        public static Contacts create(List<Contact> contacts, String id) {
            return new AutoValue_Certificate_Contacts((List<Contact>)(contacts != null ? ImmutableList.copyOf(contacts) : ImmutableList.of()), id);
        }
    }

    @AutoValue
    public static abstract class Contact {
        @Nullable
        public abstract String email();

        @Nullable
        public abstract String name();

        @Nullable
        public abstract String phone();

        @SerializedNames(value={"email", "name", "phone"})
        public static Contact create(String email, String name, String phone) {
            return new AutoValue_Certificate_Contact(email, name, phone);
        }
    }

    @AutoValue
    public static abstract class IssuerBundle {
        @Nullable
        public abstract IssuerAttributes attributes();

        @Nullable
        public abstract IssuerCredentials credentials();

        @Nullable
        public abstract String id();

        @Nullable
        public abstract OrganizationDetails organizationDetails();

        @Nullable
        public abstract String provider();

        @SerializedNames(value={"attributes", "credentials", "id", "org_details", "provider"})
        public static IssuerBundle create(IssuerAttributes attributes, IssuerCredentials credentials, String id, OrganizationDetails orgDetails, String provider) {
            return new AutoValue_Certificate_IssuerBundle(attributes, credentials, id, orgDetails, provider);
        }
    }

    @AutoValue
    public static abstract class AdministrationDetails {
        @Nullable
        public abstract String email();

        @Nullable
        public abstract String firstName();

        @Nullable
        public abstract String lastName();

        @Nullable
        public abstract String phoneNumber();

        @SerializedNames(value={"email", "first_name", "last_name", "phone"})
        public static AdministrationDetails create(String email, String firstName, String lastName, String phoneNumber) {
            return new AutoValue_Certificate_AdministrationDetails(email, firstName, lastName, phoneNumber);
        }
    }

    @AutoValue
    public static abstract class OrganizationDetails {
        public abstract List<AdministrationDetails> adminDetails();

        @Nullable
        public abstract String id();

        @SerializedNames(value={"admin_details", "id"})
        public static OrganizationDetails create(List<AdministrationDetails> adminDetails, String id) {
            return new AutoValue_Certificate_OrganizationDetails((List<AdministrationDetails>)(adminDetails != null ? ImmutableList.copyOf(adminDetails) : ImmutableList.of()), id);
        }
    }

    @AutoValue
    public static abstract class IssuerCredentials {
        @Nullable
        public abstract String accountId();

        @Nullable
        public abstract String password();

        @SerializedNames(value={"account_id", "pwd"})
        public static IssuerCredentials create(String accountId, String password) {
            return new AutoValue_Certificate_IssuerCredentials(accountId, password);
        }
    }

    @AutoValue
    public static abstract class IssuerAttributes {
        @Nullable
        public abstract Integer created();

        @Nullable
        public abstract Boolean enabled();

        @Nullable
        public abstract Integer updated();

        @SerializedNames(value={"created", "enabled", "updated"})
        public static IssuerAttributes create(Integer created, Boolean enabled, Integer updated) {
            return new AutoValue_Certificate_IssuerAttributes(created, enabled, updated);
        }
    }

    @AutoValue
    public static abstract class CertificateIssuer {
        public abstract String id();

        public abstract String provider();

        @SerializedNames(value={"id", "provider"})
        public static CertificateIssuer create(String id, String provider) {
            return new AutoValue_Certificate_CertificateIssuer(id, provider);
        }
    }

    @AutoValue
    public static abstract class CertificateBundle {
        @Nullable
        public abstract CertificateAttributes attributes();

        @Nullable
        public abstract String certificate();

        @Nullable
        public abstract String contentType();

        @Nullable
        public abstract String id();

        @Nullable
        public abstract String keyId();

        @Nullable
        public abstract CertificatePolicy policy();

        @Nullable
        public abstract String secretId();

        @Nullable
        public abstract Map<String, String> tags();

        @Nullable
        public abstract String thumbprint();

        @SerializedNames(value={"attributes", "cer", "contentType", "id", "kid", "policy", "sid", "tags", "x5t"})
        public static CertificateBundle create(CertificateAttributes attributes, String certificate, String contentType, String id, String keyId, CertificatePolicy policy, String secretId, Map<String, String> tags, String thumbprint) {
            return new AutoValue_Certificate_CertificateBundle(attributes, certificate, contentType, id, keyId, policy, secretId, (Map<String, String>)(tags != null ? ImmutableMap.copyOf(tags) : null), thumbprint);
        }
    }

    @AutoValue
    public static abstract class CertificateOperation {
        @Nullable
        public abstract Boolean cancellationRequested();

        @Nullable
        public abstract String csr();

        @Nullable
        public abstract CertificateError error();

        @Nullable
        public abstract String id();

        @Nullable
        public abstract IssuerParameters issuer();

        @Nullable
        public abstract String requestId();

        @Nullable
        public abstract String status();

        @Nullable
        public abstract String statusDetails();

        @Nullable
        public abstract String target();

        @SerializedNames(value={"cancellation_requested", "csr", "error", "id", "issuer", "request_id", "status", "status_details", "target"})
        public static CertificateOperation create(boolean cancellationRequested, String csr, CertificateError error, String id, IssuerParameters issuer, String requestId, String status, String statusDetails, String target) {
            return new AutoValue_Certificate_CertificateOperation(cancellationRequested, csr, error, id, issuer, requestId, status, statusDetails, target);
        }
    }

    @AutoValue
    public static abstract class CertificateError {
        @Nullable
        public abstract String code();

        @Nullable
        public abstract String message();

        @SerializedNames(value={"code", "message"})
        public static CertificateError create(String code, String message) {
            return new AutoValue_Certificate_CertificateError(code, message);
        }
    }

    @AutoValue
    public static abstract class CertificatePolicy {
        @Nullable
        public abstract CertificateAttributes attributes();

        @Nullable
        public abstract String id();

        @Nullable
        public abstract IssuerParameters issuer();

        @Nullable
        public abstract KeyProperties keyProps();

        public abstract List<LifetimeAction> lifetimeActions();

        @Nullable
        public abstract SecretProperties secretProps();

        @Nullable
        public abstract X509CertificateProperties x509props();

        @SerializedNames(value={"attributes", "id", "issuer", "key_props", "lifetime_actions", "secret_props", "x509_props"})
        public static CertificatePolicy create(CertificateAttributes attributes, String id, IssuerParameters issuer, KeyProperties keyProps, List<LifetimeAction> lifetimeActions, SecretProperties secretProperties, X509CertificateProperties x509Props) {
            return new AutoValue_Certificate_CertificatePolicy(attributes, id, issuer, keyProps, (List<LifetimeAction>)(lifetimeActions != null ? ImmutableList.copyOf(lifetimeActions) : ImmutableList.of()), secretProperties, x509Props);
        }
    }

    @AutoValue
    public static abstract class X509CertificateProperties {
        public abstract List<String> enhancedKeyUsage();

        public abstract List<String> keyUsage();

        @Nullable
        public abstract SubjectAlternativeNames subjectAltNames();

        @Nullable
        public abstract String subject();

        @Nullable
        public abstract Integer validityMonths();

        @SerializedNames(value={"ekus", "key_usage", "sans", "subject", "validity_months"})
        public static X509CertificateProperties create(List<String> enhancedKeyUsage, List<String> keyUsage, SubjectAlternativeNames subjectAltNames, String subject, Integer validityMonths) {
            return new AutoValue_Certificate_X509CertificateProperties((List<String>)(enhancedKeyUsage != null ? ImmutableList.copyOf(enhancedKeyUsage) : ImmutableList.of()), (List<String>)(keyUsage != null ? ImmutableList.copyOf(keyUsage) : ImmutableList.of()), subjectAltNames, subject, validityMonths);
        }
    }

    @AutoValue
    public static abstract class SubjectAlternativeNames {
        public abstract List<String> dnsNames();

        public abstract List<String> emails();

        public abstract List<String> upns();

        @SerializedNames(value={"dns_names", "emails", "upns"})
        public static SubjectAlternativeNames create(List<String> dnsNames, List<String> emails, List<String> upns) {
            return new AutoValue_Certificate_SubjectAlternativeNames((List<String>)(dnsNames != null ? ImmutableList.copyOf(dnsNames) : ImmutableList.of()), (List<String>)(emails != null ? ImmutableList.copyOf(emails) : ImmutableList.of()), (List<String>)(upns != null ? ImmutableList.copyOf(upns) : ImmutableList.of()));
        }
    }

    @AutoValue
    public static abstract class SecretProperties {
        public abstract String contentType();

        @SerializedNames(value={"contentType"})
        public static SecretProperties create(String contentType) {
            return new AutoValue_Certificate_SecretProperties(contentType);
        }
    }

    @AutoValue
    public static abstract class LifetimeAction {
        public abstract LifetimeActionAction action();

        public abstract LifetimeActionTrigger trigger();

        @SerializedNames(value={"action", "trigger"})
        public static LifetimeAction create(LifetimeActionAction action, LifetimeActionTrigger trigger) {
            return new AutoValue_Certificate_LifetimeAction(action, trigger);
        }
    }

    @AutoValue
    public static abstract class LifetimeActionAction {
        public abstract String actionType();

        @SerializedNames(value={"action_type"})
        public static LifetimeActionAction create(String actionType) {
            return new AutoValue_Certificate_LifetimeActionAction(actionType);
        }
    }

    @AutoValue
    public static abstract class LifetimeActionTrigger {
        @Nullable
        public abstract Integer daysBeforeExpiry();

        @Nullable
        public abstract Integer lifetimePercentage();

        @SerializedNames(value={"days_before_expiry", "lifetime_percentage"})
        public static LifetimeActionTrigger create(Integer daysBeforeExpiry, Integer lifetimePercentage) {
            return new AutoValue_Certificate_LifetimeActionTrigger(daysBeforeExpiry, lifetimePercentage);
        }
    }

    @AutoValue
    public static abstract class KeyProperties {
        @Nullable
        public abstract Boolean exportable();

        @Nullable
        public abstract Integer keySize();

        @Nullable
        public abstract String keyType();

        @Nullable
        public abstract Boolean reuseKey();

        @SerializedNames(value={"exportable", "key_size", "kty", "reuse_key"})
        public static KeyProperties create(boolean exportable, Integer keySize, String keyType, boolean reuseKey) {
            return new AutoValue_Certificate_KeyProperties(exportable, keySize, keyType, reuseKey);
        }
    }

    @AutoValue
    public static abstract class IssuerParameters {
        @Nullable
        public abstract String certType();

        @Nullable
        public abstract String name();

        @SerializedNames(value={"cty", "name"})
        public static IssuerParameters create(String certType, String name) {
            return new AutoValue_Certificate_IssuerParameters(certType, name);
        }
    }
}

