/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.azurecompute.arm.domain;

import java.util.List;
import org.jclouds.azurecompute.arm.domain.DataDisk;
import org.jclouds.azurecompute.arm.domain.ImageReference;
import org.jclouds.azurecompute.arm.domain.OSDisk;
import org.jclouds.azurecompute.arm.domain.StorageProfile;
import org.jclouds.javax.annotation.Nullable;

final class AutoValue_StorageProfile
extends StorageProfile {
    private final ImageReference imageReference;
    private final OSDisk osDisk;
    private final List<DataDisk> dataDisks;

    private AutoValue_StorageProfile(@Nullable ImageReference imageReference, OSDisk osDisk, @Nullable List<DataDisk> dataDisks) {
        this.imageReference = imageReference;
        this.osDisk = osDisk;
        this.dataDisks = dataDisks;
    }

    @Override
    @Nullable
    public ImageReference imageReference() {
        return this.imageReference;
    }

    @Override
    public OSDisk osDisk() {
        return this.osDisk;
    }

    @Override
    @Nullable
    public List<DataDisk> dataDisks() {
        return this.dataDisks;
    }

    public String toString() {
        return "StorageProfile{imageReference=" + String.valueOf(this.imageReference) + ", osDisk=" + String.valueOf(this.osDisk) + ", dataDisks=" + String.valueOf(this.dataDisks) + "}";
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o instanceof StorageProfile) {
            StorageProfile that = (StorageProfile)o;
            return (this.imageReference == null ? that.imageReference() == null : this.imageReference.equals(that.imageReference())) && this.osDisk.equals(that.osDisk()) && (this.dataDisks == null ? that.dataDisks() == null : this.dataDisks.equals(that.dataDisks()));
        }
        return false;
    }

    public int hashCode() {
        int h$ = 1;
        h$ *= 1000003;
        h$ ^= this.imageReference == null ? 0 : this.imageReference.hashCode();
        h$ *= 1000003;
        h$ ^= this.osDisk.hashCode();
        h$ *= 1000003;
        return h$ ^= this.dataDisks == null ? 0 : this.dataDisks.hashCode();
    }

    @Override
    public StorageProfile.Builder toBuilder() {
        return new Builder(this);
    }

    static final class Builder
    extends StorageProfile.Builder {
        private ImageReference imageReference;
        private OSDisk osDisk;
        private List<DataDisk> dataDisks;

        Builder() {
        }

        private Builder(StorageProfile source) {
            this.imageReference = source.imageReference();
            this.osDisk = source.osDisk();
            this.dataDisks = source.dataDisks();
        }

        @Override
        public StorageProfile.Builder imageReference(@Nullable ImageReference imageReference) {
            this.imageReference = imageReference;
            return this;
        }

        @Override
        public StorageProfile.Builder osDisk(OSDisk osDisk) {
            if (osDisk == null) {
                throw new NullPointerException("Null osDisk");
            }
            this.osDisk = osDisk;
            return this;
        }

        @Override
        public StorageProfile.Builder dataDisks(@Nullable List<DataDisk> dataDisks) {
            this.dataDisks = dataDisks;
            return this;
        }

        @Override
        @Nullable
        List<DataDisk> dataDisks() {
            return this.dataDisks;
        }

        @Override
        StorageProfile autoBuild() {
            Object missing = "";
            if (this.osDisk == null) {
                missing = (String)missing + " osDisk";
            }
            if (!((String)missing).isEmpty()) {
                throw new IllegalStateException("Missing required properties:" + (String)missing);
            }
            return new AutoValue_StorageProfile(this.imageReference, this.osDisk, this.dataDisks);
        }
    }
}

