/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.azurecompute.arm.compute.config;

import com.google.common.base.Function;
import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import com.google.inject.Module;
import com.google.inject.Provides;
import com.google.inject.TypeLiteral;
import jakarta.inject.Singleton;
import org.jclouds.azurecompute.arm.compute.AzureComputeService;
import org.jclouds.azurecompute.arm.compute.AzureComputeServiceAdapter;
import org.jclouds.azurecompute.arm.compute.domain.ResourceGroupAndNameAndIngressRules;
import org.jclouds.azurecompute.arm.compute.extensions.AzureComputeImageExtension;
import org.jclouds.azurecompute.arm.compute.extensions.AzureComputeSecurityGroupExtension;
import org.jclouds.azurecompute.arm.compute.functions.LocationToLocation;
import org.jclouds.azurecompute.arm.compute.functions.NetworkSecurityGroupToSecurityGroup;
import org.jclouds.azurecompute.arm.compute.functions.NetworkSecurityRuleToIpPermission;
import org.jclouds.azurecompute.arm.compute.functions.VMHardwareToHardware;
import org.jclouds.azurecompute.arm.compute.functions.VMImageToImage;
import org.jclouds.azurecompute.arm.compute.functions.VirtualMachineToNodeMetadata;
import org.jclouds.azurecompute.arm.compute.loaders.CreateSecurityGroupIfNeeded;
import org.jclouds.azurecompute.arm.compute.loaders.DefaultResourceGroup;
import org.jclouds.azurecompute.arm.compute.options.AzureTemplateOptions;
import org.jclouds.azurecompute.arm.compute.strategy.CreateResourcesThenCreateNodes;
import org.jclouds.azurecompute.arm.domain.NetworkSecurityGroup;
import org.jclouds.azurecompute.arm.domain.NetworkSecurityRule;
import org.jclouds.azurecompute.arm.domain.ResourceGroup;
import org.jclouds.azurecompute.arm.domain.VMHardware;
import org.jclouds.azurecompute.arm.domain.VMImage;
import org.jclouds.azurecompute.arm.domain.VirtualMachine;
import org.jclouds.compute.ComputeService;
import org.jclouds.compute.ComputeServiceAdapter;
import org.jclouds.compute.config.ComputeServiceAdapterContextModule;
import org.jclouds.compute.domain.Hardware;
import org.jclouds.compute.domain.Image;
import org.jclouds.compute.domain.NodeMetadata;
import org.jclouds.compute.domain.SecurityGroup;
import org.jclouds.compute.extensions.ImageExtension;
import org.jclouds.compute.extensions.SecurityGroupExtension;
import org.jclouds.compute.functions.NodeAndTemplateOptionsToStatement;
import org.jclouds.compute.functions.NodeAndTemplateOptionsToStatementWithoutPublicKey;
import org.jclouds.compute.options.TemplateOptions;
import org.jclouds.compute.strategy.CreateNodesInGroupThenAddToSet;
import org.jclouds.domain.Location;
import org.jclouds.net.domain.IpPermission;
import org.jclouds.util.PasswordGenerator;

public class AzureComputeServiceContextModule
extends ComputeServiceAdapterContextModule<VirtualMachine, VMHardware, VMImage, org.jclouds.azurecompute.arm.domain.Location> {
    protected void configure() {
        super.configure();
        this.bind((TypeLiteral)new TypeLiteral<ComputeServiceAdapter<VirtualMachine, VMHardware, VMImage, org.jclouds.azurecompute.arm.domain.Location>>(){}).to(AzureComputeServiceAdapter.class);
        this.bind((TypeLiteral)new TypeLiteral<Function<VMImage, Image>>(){}).to(VMImageToImage.class);
        this.bind((TypeLiteral)new TypeLiteral<Function<VMHardware, Hardware>>(){}).to(VMHardwareToHardware.class);
        this.bind((TypeLiteral)new TypeLiteral<Function<VirtualMachine, NodeMetadata>>(){}).to(VirtualMachineToNodeMetadata.class);
        this.bind((TypeLiteral)new TypeLiteral<Function<org.jclouds.azurecompute.arm.domain.Location, Location>>(){}).to(LocationToLocation.class);
        this.bind((TypeLiteral)new TypeLiteral<Function<NetworkSecurityGroup, SecurityGroup>>(){}).to(NetworkSecurityGroupToSecurityGroup.class);
        this.bind((TypeLiteral)new TypeLiteral<Function<NetworkSecurityRule, IpPermission>>(){}).to(NetworkSecurityRuleToIpPermission.class);
        this.bind(ComputeService.class).to(AzureComputeService.class);
        this.install((Module)new ComputeServiceAdapterContextModule.LocationsFromComputeServiceAdapterModule<VirtualMachine, VMHardware, VMImage, org.jclouds.azurecompute.arm.domain.Location>(){});
        this.bind(TemplateOptions.class).to(AzureTemplateOptions.class);
        this.bind(NodeAndTemplateOptionsToStatement.class).to(NodeAndTemplateOptionsToStatementWithoutPublicKey.class);
        this.bind(CreateNodesInGroupThenAddToSet.class).to(CreateResourcesThenCreateNodes.class);
        this.bind((TypeLiteral)new TypeLiteral<CacheLoader<ResourceGroupAndNameAndIngressRules, String>>(){}).to(CreateSecurityGroupIfNeeded.class);
        this.bind((TypeLiteral)new TypeLiteral<CacheLoader<String, ResourceGroup>>(){}).to(DefaultResourceGroup.class);
        this.bind((TypeLiteral)new TypeLiteral<ImageExtension>(){}).to(AzureComputeImageExtension.class);
        this.bind((TypeLiteral)new TypeLiteral<SecurityGroupExtension>(){}).to(AzureComputeSecurityGroupExtension.class);
    }

    @Provides
    @Singleton
    protected PasswordGenerator.Config providePasswordGenerator() {
        return new PasswordGenerator().lower().min(2).max(10).upper().min(2).max(10).numbers().min(2).max(10).symbols().min(2).max(10);
    }

    @Provides
    @Singleton
    protected final LoadingCache<ResourceGroupAndNameAndIngressRules, String> securityGroupMap(CacheLoader<ResourceGroupAndNameAndIngressRules, String> in) {
        return CacheBuilder.newBuilder().build(in);
    }

    @Provides
    @Singleton
    protected final LoadingCache<String, ResourceGroup> defaultResourceGroup(CacheLoader<String, ResourceGroup> in) {
        return CacheBuilder.newBuilder().build(in);
    }
}

