/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.aws.ec2.xml;

import com.google.common.base.Supplier;
import jakarta.inject.Inject;
import org.jclouds.aws.util.AWSUtils;
import org.jclouds.ec2.domain.ReservedInstancesOffering;
import org.jclouds.http.functions.ParseSax;
import org.jclouds.location.Region;
import org.jclouds.rest.internal.GeneratedHttpRequest;

public class ReservedInstancesOfferingHandler
extends ParseSax.HandlerForGeneratedRequestWithResult<ReservedInstancesOffering> {
    @Inject
    @Region
    Supplier<String> defaultRegion;
    private StringBuilder currentText = new StringBuilder();
    private String availabilityZone;
    private long duration = 0L;
    private float fixedPrice = 0.0f;
    private String instanceType;
    private String productDescription;
    private String id;
    private float usagePrice = 0.0f;

    public ReservedInstancesOffering getResult() {
        String region = AWSUtils.findRegionInArgsOrNull((GeneratedHttpRequest)this.getRequest());
        if (region == null) {
            region = (String)this.defaultRegion.get();
        }
        ReservedInstancesOffering returnVal = new ReservedInstancesOffering(region, this.availabilityZone, this.duration, this.fixedPrice, this.instanceType, this.productDescription, this.id, this.usagePrice);
        this.availabilityZone = null;
        this.duration = 0L;
        this.fixedPrice = 0.0f;
        this.instanceType = null;
        this.productDescription = null;
        this.id = null;
        this.usagePrice = 0.0f;
        return returnVal;
    }

    public void endElement(String uri, String name, String qName) {
        if (qName.equalsIgnoreCase("reservedInstancesOfferingId")) {
            this.id = this.currentText.toString().trim();
        } else if (qName.equalsIgnoreCase("availabilityZone")) {
            this.availabilityZone = this.currentText.toString().trim();
        } else if (qName.equalsIgnoreCase("duration")) {
            this.duration = Long.parseLong(this.currentText.toString().trim());
        } else if (qName.equalsIgnoreCase("fixedPrice")) {
            this.fixedPrice = Float.parseFloat(this.currentText.toString().trim());
        } else if (qName.equalsIgnoreCase("instanceType")) {
            this.instanceType = this.currentText.toString().trim();
        } else if (qName.equalsIgnoreCase("productDescription")) {
            this.productDescription = this.currentText.toString().trim();
        } else if (qName.equalsIgnoreCase("usagePrice")) {
            this.usagePrice = Float.parseFloat(this.currentText.toString().trim());
        }
        this.currentText.setLength(0);
    }

    public void characters(char[] ch, int start, int length) {
        this.currentText.append(ch, start, length);
    }
}

