/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.aws.ec2.features;

import com.google.common.collect.Multimap;
import jakarta.inject.Named;
import jakarta.ws.rs.FormParam;
import jakarta.ws.rs.POST;
import jakarta.ws.rs.Path;
import java.util.Set;
import org.jclouds.Fallbacks;
import org.jclouds.aws.ec2.domain.PlacementGroup;
import org.jclouds.aws.ec2.xml.DescribePlacementGroupsResponseHandler;
import org.jclouds.aws.filters.FormSigner;
import org.jclouds.ec2.binders.BindFiltersToIndexedFormParams;
import org.jclouds.javax.annotation.Nullable;
import org.jclouds.location.functions.RegionToEndpointOrProviderIfNull;
import org.jclouds.rest.annotations.BinderParam;
import org.jclouds.rest.annotations.EndpointParam;
import org.jclouds.rest.annotations.Fallback;
import org.jclouds.rest.annotations.FormParams;
import org.jclouds.rest.annotations.RequestFilters;
import org.jclouds.rest.annotations.VirtualHost;
import org.jclouds.rest.annotations.XMLResponseParser;

@RequestFilters(value={FormSigner.class})
@VirtualHost
public interface PlacementGroupApi {
    @Named(value="CreatePlacementGroup")
    @POST
    @Path(value="/")
    @FormParams(keys={"Action"}, values={"CreatePlacementGroup"})
    public void createPlacementGroupInRegion(@EndpointParam(parser=RegionToEndpointOrProviderIfNull.class) @Nullable String var1, @FormParam(value="GroupName") String var2, @FormParam(value="Strategy") String var3);

    @Named(value="CreatePlacementGroup")
    @POST
    @Path(value="/")
    @FormParams(keys={"Action", "Strategy"}, values={"CreatePlacementGroup", "cluster"})
    public void createPlacementGroupInRegion(@EndpointParam(parser=RegionToEndpointOrProviderIfNull.class) @Nullable String var1, @FormParam(value="GroupName") String var2);

    @Named(value="DeletePlacementGroup")
    @POST
    @Path(value="/")
    @FormParams(keys={"Action"}, values={"DeletePlacementGroup"})
    @Fallback(value=Fallbacks.VoidOnNotFoundOr404.class)
    public void deletePlacementGroupInRegion(@EndpointParam(parser=RegionToEndpointOrProviderIfNull.class) @Nullable String var1, @FormParam(value="GroupName") String var2);

    @Named(value="DescribePlacementGroups")
    @POST
    @Path(value="/")
    @FormParams(keys={"Action"}, values={"DescribePlacementGroups"})
    @XMLResponseParser(value=DescribePlacementGroupsResponseHandler.class)
    @Fallback(value=Fallbacks.EmptySetOnNotFoundOr404.class)
    public Set<PlacementGroup> describePlacementGroupsInRegion(@EndpointParam(parser=RegionToEndpointOrProviderIfNull.class) @Nullable String var1, String ... var2);

    @Named(value="DescribePlacementGroups")
    @POST
    @Path(value="/")
    @FormParams(keys={"Action"}, values={"DescribePlacementGroups"})
    @XMLResponseParser(value=DescribePlacementGroupsResponseHandler.class)
    @Fallback(value=Fallbacks.EmptySetOnNotFoundOr404.class)
    public Set<PlacementGroup> describePlacementGroupsInRegionWithFilter(@EndpointParam(parser=RegionToEndpointOrProviderIfNull.class) @Nullable String var1, @BinderParam(value=BindFiltersToIndexedFormParams.class) Multimap<String, String> var2);
}

