/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.aws.ec2.compute.strategy;

import com.google.common.base.Function;
import com.google.common.base.Preconditions;
import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import com.google.common.base.Supplier;
import com.google.common.collect.Iterables;
import com.google.common.collect.Multimap;
import com.google.common.util.concurrent.ListeningExecutorService;
import com.google.inject.Inject;
import jakarta.inject.Named;
import jakarta.inject.Singleton;
import java.util.Set;
import org.jclouds.aws.ec2.AWSEC2Api;
import org.jclouds.aws.ec2.domain.SpotInstanceRequest;
import org.jclouds.aws.ec2.features.SpotInstanceApi;
import org.jclouds.aws.ec2.functions.SpotInstanceRequestToAWSRunningInstance;
import org.jclouds.compute.domain.NodeMetadata;
import org.jclouds.ec2.EC2Api;
import org.jclouds.ec2.compute.strategy.EC2ListNodesStrategy;
import org.jclouds.ec2.domain.RunningInstance;
import org.jclouds.location.Region;

@Singleton
public class AWSEC2ListNodesStrategy
extends EC2ListNodesStrategy {
    protected final AWSEC2Api client;
    protected final SpotInstanceRequestToAWSRunningInstance spotConverter;

    @Inject
    protected AWSEC2ListNodesStrategy(AWSEC2Api client, @Region Supplier<Set<String>> regions, Function<RunningInstance, NodeMetadata> runningInstanceToNodeMetadata, @Named(value="jclouds.user-threads") ListeningExecutorService userExecutor, SpotInstanceRequestToAWSRunningInstance spotConverter) {
        super((EC2Api)client, regions, runningInstanceToNodeMetadata, userExecutor);
        this.client = (AWSEC2Api)Preconditions.checkNotNull((Object)client, (Object)"client");
        this.spotConverter = (SpotInstanceRequestToAWSRunningInstance)Preconditions.checkNotNull((Object)spotConverter, (Object)"spotConverter");
    }

    protected Iterable<? extends RunningInstance> pollRunningInstances() {
        Iterable spots = Iterables.filter((Iterable)Iterables.transform((Iterable)Iterables.concat((Iterable)Iterables.transform((Iterable)((Iterable)this.regions.get()), this.allSpotInstancesInRegion())), (Function)this.spotConverter), (Predicate)Predicates.notNull());
        return Iterables.concat((Iterable)super.pollRunningInstances(), (Iterable)spots);
    }

    protected Iterable<? extends RunningInstance> pollRunningInstancesByRegionsAndIds(Multimap<String, String> idsByRegions) {
        Iterable spots = Iterables.filter((Iterable)Iterables.transform((Iterable)Iterables.concat((Iterable)Iterables.transform((Iterable)idsByRegions.keySet(), this.spotInstancesByIdInRegion(idsByRegions))), (Function)this.spotConverter), (Predicate)Predicates.notNull());
        Iterable superInsts = super.pollRunningInstancesByRegionsAndIds(idsByRegions);
        return Iterables.concat((Iterable)superInsts, (Iterable)spots);
    }

    protected Function<String, Set<SpotInstanceRequest>> allSpotInstancesInRegion() {
        return new Function<String, Set<SpotInstanceRequest>>(){

            public Set<SpotInstanceRequest> apply(String from) {
                return ((SpotInstanceApi)AWSEC2ListNodesStrategy.this.client.getSpotInstanceApi().get()).describeSpotInstanceRequestsInRegion(from, new String[0]);
            }
        };
    }

    protected Function<String, Set<SpotInstanceRequest>> spotInstancesByIdInRegion(final Multimap<String, String> idsByRegions) {
        return new Function<String, Set<SpotInstanceRequest>>(){

            public Set<SpotInstanceRequest> apply(String from) {
                return ((SpotInstanceApi)AWSEC2ListNodesStrategy.this.client.getSpotInstanceApi().get()).describeSpotInstanceRequestsInRegion(from, (String[])Iterables.toArray((Iterable)idsByRegions.get((Object)from), String.class));
            }
        };
    }
}

