/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.aws.ec2.binders;

import com.google.common.base.Function;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Multimap;
import com.google.common.collect.Multimaps;
import jakarta.inject.Singleton;
import java.util.Map;
import java.util.Set;
import org.jclouds.aws.ec2.domain.LaunchSpecification;
import org.jclouds.aws.ec2.options.AWSRunInstancesOptions;
import org.jclouds.http.HttpRequest;
import org.jclouds.rest.Binder;

@Singleton
public class BindLaunchSpecificationToFormParams
implements Binder,
Function<LaunchSpecification, Map<String, String>> {
    public <R extends HttpRequest> R bindToRequest(R request, Object input) {
        Preconditions.checkArgument((boolean)(input instanceof LaunchSpecification), (Object)"this binder is only valid for LaunchSpecifications!");
        LaunchSpecification launchSpec = (LaunchSpecification)LaunchSpecification.class.cast(input);
        return (R)request.toBuilder().replaceFormParams((Multimap)Multimaps.forMap(this.apply(launchSpec))).build();
    }

    public Map<String, String> apply(LaunchSpecification launchSpec) {
        ImmutableMap.Builder builder = ImmutableMap.builder();
        builder.put((Object)"LaunchSpecification.ImageId", (Object)((String)Preconditions.checkNotNull((Object)launchSpec.getImageId(), (Object)"imageId")));
        if (launchSpec.getAvailabilityZone() != null) {
            builder.put((Object)"LaunchSpecification.Placement.AvailabilityZone", (Object)launchSpec.getAvailabilityZone());
        }
        AWSRunInstancesOptions options = new AWSRunInstancesOptions();
        if (!launchSpec.getBlockDeviceMappings().isEmpty()) {
            options.withBlockDeviceMappings((Set)launchSpec.getBlockDeviceMappings());
        }
        if (!launchSpec.getSecurityGroupNames().isEmpty()) {
            options.withSecurityGroups(launchSpec.getSecurityGroupNames());
        }
        if (!launchSpec.getSecurityGroupIds().isEmpty()) {
            options.withSecurityGroupIds(launchSpec.getSecurityGroupIds());
        }
        options.asType((String)Preconditions.checkNotNull((Object)launchSpec.getInstanceType(), (Object)"instanceType"));
        if (launchSpec.getSubnetId() != null) {
            options.withSubnetId(launchSpec.getSubnetId());
        }
        if (launchSpec.getKernelId() != null) {
            options.withKernelId(launchSpec.getKernelId());
        }
        if (launchSpec.getKeyName() != null) {
            options.withKeyName(launchSpec.getKeyName());
        }
        if (launchSpec.getRamdiskId() != null) {
            options.withRamdisk(launchSpec.getRamdiskId());
        }
        if (Boolean.TRUE.equals(launchSpec.isMonitoringEnabled())) {
            options.enableMonitoring();
        }
        if (launchSpec.getUserData() != null) {
            options.withUserData(launchSpec.getUserData());
        }
        if (launchSpec.getIAMInstanceProfile().isPresent()) {
            LaunchSpecification.IAMInstanceProfileRequest profile = (LaunchSpecification.IAMInstanceProfileRequest)launchSpec.getIAMInstanceProfile().get();
            if (profile.getArn().isPresent()) {
                options.withIAMInstanceProfileArn((String)profile.getArn().get());
            }
            if (profile.getName().isPresent()) {
                options.withIAMInstanceProfileName((String)profile.getName().get());
            }
        }
        for (Map.Entry entry : options.buildFormParameters().entries()) {
            builder.put((Object)("LaunchSpecification." + (String)entry.getKey()), (Object)((String)entry.getValue()));
        }
        return builder.build();
    }
}

