/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.googlecomputeengine.functions.internal;

import com.google.common.annotations.Beta;
import com.google.common.base.Function;
import com.google.common.base.Optional;
import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import com.google.common.collect.Iterables;
import org.jclouds.collect.IterableWithMarker;
import org.jclouds.collect.PagedIterable;
import org.jclouds.collect.PagedIterables;
import org.jclouds.googlecomputeengine.domain.ListPage;
import org.jclouds.googlecomputeengine.options.ListOptions;
import org.jclouds.http.HttpRequest;
import org.jclouds.reflect.Invocation;
import org.jclouds.rest.InvocationContext;
import org.jclouds.rest.internal.GeneratedHttpRequest;

@Beta
public abstract class BaseWithZoneToPagedIterable<T, I extends BaseWithZoneToPagedIterable<T, I>>
implements Function<ListPage<T>, PagedIterable<T>>,
InvocationContext<I> {
    private GeneratedHttpRequest request;

    public PagedIterable<T> apply(ListPage<T> input) {
        if (input.nextMarker() == null) {
            return PagedIterables.of(input);
        }
        Optional project = Iterables.tryFind((Iterable)((Invocation)this.request.getCaller().get()).getArgs(), (Predicate)Predicates.instanceOf(String.class));
        Optional zone = Iterables.tryFind((Iterable)this.request.getInvocation().getArgs(), (Predicate)Predicates.instanceOf(String.class));
        Optional listOptions = Iterables.tryFind((Iterable)this.request.getInvocation().getArgs(), (Predicate)Predicates.instanceOf(ListOptions.class));
        assert (project.isPresent()) : String.format("programming error, method %s should have a string param for the project", ((Invocation)this.request.getCaller().get()).getInvokable());
        assert (zone.isPresent()) : String.format("programming error, method %s should have a string param for the zone", ((Invocation)this.request.getCaller().get()).getInvokable());
        return PagedIterables.advance(input, this.fetchNextPage(project.get().toString(), zone.get().toString(), (ListOptions)((Object)listOptions.orNull())));
    }

    protected abstract Function<Object, IterableWithMarker<T>> fetchNextPage(String var1, String var2, ListOptions var3);

    public I setContext(HttpRequest request) {
        this.request = (GeneratedHttpRequest)GeneratedHttpRequest.class.cast(request);
        return (I)this;
    }
}

