/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.googlecomputeengine.domain;

import com.google.common.base.Objects;
import com.google.common.base.Preconditions;
import com.google.common.base.Splitter;
import com.google.common.collect.Iterables;

public class SlashEncodedIds {
    protected final String firstId;
    protected final String secondId;

    public static SlashEncodedIds fromSlashEncoded(String id) {
        Iterable parts = Splitter.on((char)'/').split((CharSequence)Preconditions.checkNotNull((Object)id, (Object)"id"));
        Preconditions.checkArgument((Iterables.size((Iterable)parts) == 2 ? 1 : 0) != 0, (Object)"id must be in format firstId/secondId");
        return new SlashEncodedIds((String)Iterables.get((Iterable)parts, (int)0), (String)Iterables.get((Iterable)parts, (int)1));
    }

    public static SlashEncodedIds fromTwoIds(String firstId, String secondId) {
        return new SlashEncodedIds(firstId, secondId);
    }

    private static String slashEncodeTwoIds(String firstId, String secondId) {
        return (String)Preconditions.checkNotNull((Object)firstId, (Object)"firstId") + "/" + (String)Preconditions.checkNotNull((Object)secondId, (Object)"secondId");
    }

    public String slashEncode() {
        return SlashEncodedIds.slashEncodeTwoIds(this.firstId, this.secondId);
    }

    protected SlashEncodedIds(String firstId, String secondId) {
        this.firstId = (String)Preconditions.checkNotNull((Object)firstId, (Object)"firstId");
        this.secondId = (String)Preconditions.checkNotNull((Object)secondId, (Object)"secondId");
    }

    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{this.firstId, this.secondId});
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        SlashEncodedIds other = (SlashEncodedIds)obj;
        return Objects.equal((Object)this.firstId, (Object)other.firstId) && Objects.equal((Object)this.secondId, (Object)other.secondId);
    }

    public String getFirstId() {
        return this.firstId;
    }

    public String getSecondId() {
        return this.secondId;
    }

    public String toString() {
        return "[firstId=" + this.firstId + ", secondId=" + this.secondId + "]";
    }
}

