/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.googlecomputeengine.domain;

import com.google.common.annotations.Beta;
import com.google.common.base.Objects;
import com.google.common.base.Optional;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import java.beans.ConstructorProperties;
import java.net.URI;
import java.util.Date;
import java.util.List;
import org.jclouds.googlecomputeengine.domain.Resource;
import org.jclouds.http.HttpResponse;
import org.jclouds.javax.annotation.Nullable;

@Beta
public class Operation
extends Resource {
    private final URI targetLink;
    private final Optional<String> targetId;
    private final Optional<String> clientOperationId;
    private final Status status;
    private final Optional<String> statusMessage;
    private final String user;
    private final Optional<Integer> progress;
    private final Date insertTime;
    private final Optional<Date> startTime;
    private final Optional<Date> endTime;
    private final Optional<HttpResponse> httpError;
    private final String operationType;
    private final List<Error> errors;
    private final Optional<URI> zone;
    private final Optional<URI> region;

    protected Operation(String id, Date creationTimestamp, URI selfLink, String name, String description, URI targetLink, String targetId, String clientOperationId, Status status, String statusMessage, String user, Integer progress, Date insertTime, Date startTime, Date endTime, Integer httpErrorStatusCode, String httpErrorMessage, String operationType, @Nullable List<Error> errors, URI region, URI zone) {
        super(Resource.Kind.OPERATION, id, creationTimestamp, selfLink, name, description);
        this.targetLink = (URI)Preconditions.checkNotNull((Object)targetLink, (String)"targetLink of %s", (Object[])new Object[]{name});
        this.targetId = Optional.fromNullable((Object)targetId);
        this.clientOperationId = Optional.fromNullable((Object)clientOperationId);
        this.status = (Status)((Object)Preconditions.checkNotNull((Object)((Object)status), (String)"status of %s", (Object[])new Object[]{name}));
        this.statusMessage = Optional.fromNullable((Object)statusMessage);
        this.user = (String)Preconditions.checkNotNull((Object)user, (String)"user of %s", (Object[])new Object[]{name});
        this.progress = Optional.fromNullable((Object)progress);
        this.insertTime = (Date)Preconditions.checkNotNull((Object)insertTime, (String)"insertTime of %s", (Object[])new Object[]{name});
        this.startTime = Optional.fromNullable((Object)startTime);
        this.endTime = Optional.fromNullable((Object)endTime);
        this.httpError = httpErrorStatusCode != null && httpErrorStatusCode != 0 ? Optional.of((Object)HttpResponse.builder().statusCode(httpErrorStatusCode.intValue()).message(httpErrorMessage).build()) : Optional.absent();
        this.operationType = (String)Preconditions.checkNotNull((Object)operationType, (String)"insertTime of %s", (Object[])new Object[]{name});
        this.errors = errors == null ? ImmutableList.of() : ImmutableList.copyOf(errors);
        this.region = Optional.fromNullable((Object)region);
        this.zone = Optional.fromNullable((Object)zone);
    }

    public URI getTargetLink() {
        return this.targetLink;
    }

    public Optional<String> getClientOperationId() {
        return this.clientOperationId;
    }

    public Optional<String> getTargetId() {
        return this.targetId;
    }

    public Optional<URI> getRegion() {
        return this.region;
    }

    public Optional<URI> getZone() {
        return this.zone;
    }

    public Status getStatus() {
        return this.status;
    }

    public Optional<String> getStatusMessage() {
        return this.statusMessage;
    }

    public String getUser() {
        return this.user;
    }

    public Optional<Integer> getProgress() {
        return this.progress;
    }

    public Date getInsertTime() {
        return this.insertTime;
    }

    public Optional<Date> getStartTime() {
        return this.startTime;
    }

    public Optional<Date> getEndTime() {
        return this.endTime;
    }

    public Optional<HttpResponse> getHttpError() {
        return this.httpError;
    }

    public String getOperationType() {
        return this.operationType;
    }

    public List<Error> getErrors() {
        return this.errors;
    }

    @Override
    protected Objects.ToStringHelper string() {
        return super.string().omitNullValues().add("targetLink", (Object)this.targetLink).add("targetId", this.targetId.orNull()).add("clientOperationId", this.clientOperationId.orNull()).add("status", (Object)this.status).add("statusMessage", this.statusMessage.orNull()).add("user", (Object)this.user).add("progress", this.progress.orNull()).add("insertTime", (Object)this.insertTime).add("startTime", this.startTime.orNull()).add("endTime", this.endTime.orNull()).add("httpError", this.httpError.orNull()).add("operationType", (Object)this.operationType).add("errors", this.errors).add("region", this.region.orNull()).add("zone", this.zone.orNull());
    }

    @Override
    public String toString() {
        return this.string().toString();
    }

    public static Builder builder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder().fromOperation(this);
    }

    public static final class Error {
        private final String code;
        private final Optional<String> location;
        private final Optional<String> message;

        @ConstructorProperties(value={"code", "location", "message"})
        private Error(String code, String location, String message) {
            this.code = (String)Preconditions.checkNotNull((Object)code, (Object)"code");
            this.location = Optional.fromNullable((Object)location);
            this.message = Optional.fromNullable((Object)message);
        }

        public String getCode() {
            return this.code;
        }

        public Optional<String> getLocation() {
            return this.location;
        }

        public Optional<String> getMessage() {
            return this.message;
        }

        public int hashCode() {
            return Objects.hashCode((Object[])new Object[]{this.code, this.location, this.message});
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null || this.getClass() != obj.getClass()) {
                return false;
            }
            Error that = (Error)Error.class.cast(obj);
            return Objects.equal((Object)this.code, (Object)that.code) && Objects.equal(this.location, that.location) && Objects.equal(this.message, that.message);
        }

        protected Objects.ToStringHelper string() {
            return Objects.toStringHelper((Object)this).omitNullValues().add("code", (Object)this.code).add("location", this.location.orNull()).add("message", this.message.orNull());
        }

        public String toString() {
            return this.string().toString();
        }

        public static Builder builder() {
            return new Builder();
        }

        public Builder toBuilder() {
            return Error.builder().fromOperationErrorDetail(this);
        }

        public static final class Builder {
            private String code;
            private String location;
            private String message;

            public Builder code(String code) {
                this.code = code;
                return this;
            }

            public Builder location(String location) {
                this.location = location;
                return this;
            }

            public Builder message(String message) {
                this.message = message;
                return this;
            }

            public Error build() {
                return new Error(this.code, this.location, this.message);
            }

            public Builder fromOperationErrorDetail(Error in) {
                return new Builder().code(in.getCode()).location((String)in.getLocation().orNull()).message((String)in.getMessage().orNull());
            }
        }
    }

    public static final class Builder
    extends Resource.Builder<Builder> {
        private URI targetLink;
        private String targetId;
        private String clientOperationId;
        private Status status;
        private String statusMessage;
        private String user;
        private Integer progress;
        private Date insertTime;
        private Date startTime;
        private Date endTime;
        private Integer httpErrorStatusCode;
        private String httpErrorMessage;
        private String operationType;
        private ImmutableList.Builder<Error> errors = ImmutableList.builder();
        private URI region;
        private URI zone;

        public Builder targetLink(URI targetLink) {
            this.targetLink = targetLink;
            return this.self();
        }

        public Builder region(URI region) {
            this.region = region;
            return this.self();
        }

        public Builder zone(URI zone) {
            this.zone = zone;
            return this.self();
        }

        public Builder targetId(String targetId) {
            this.targetId = targetId;
            return this.self();
        }

        public Builder clientOperationId(String clientOperationId) {
            this.clientOperationId = clientOperationId;
            return this.self();
        }

        public Builder status(Status status) {
            this.status = status;
            return this.self();
        }

        public Builder statusMessage(String statusMessage) {
            this.statusMessage = statusMessage;
            return this.self();
        }

        public Builder user(String user) {
            this.user = user;
            return this.self();
        }

        public Builder progress(Integer progress) {
            this.progress = progress;
            return this.self();
        }

        public Builder insertTime(Date insertTime) {
            this.insertTime = insertTime;
            return this.self();
        }

        public Builder startTime(Date startTime) {
            this.startTime = startTime;
            return this.self();
        }

        public Builder endTime(Date endTime) {
            this.endTime = endTime;
            return this.self();
        }

        public Builder httpErrorStatusCode(Integer httpErrorStatusCode) {
            this.httpErrorStatusCode = httpErrorStatusCode;
            return this.self();
        }

        public Builder httpErrorMessage(String httpErrorMessage) {
            this.httpErrorMessage = httpErrorMessage;
            return this.self();
        }

        public Builder operationType(String operationType) {
            this.operationType = operationType;
            return this.self();
        }

        public Builder errors(Iterable<Error> errors) {
            if (errors != null) {
                this.errors.addAll(errors);
            }
            return this.self();
        }

        public Builder addError(Error error) {
            this.errors.add((Object)error);
            return this.self();
        }

        @Override
        protected Builder self() {
            return this;
        }

        @Override
        public Operation build() {
            return new Operation(this.id, this.creationTimestamp, this.selfLink, this.name, this.description, this.targetLink, this.targetId, this.clientOperationId, this.status, this.statusMessage, this.user, this.progress, this.insertTime, this.startTime, this.endTime, this.httpErrorStatusCode, this.httpErrorMessage, this.operationType, (List<Error>)this.errors.build(), this.region, this.zone);
        }

        public Builder fromOperation(Operation in) {
            return ((Builder)super.fromResource(in)).targetLink(in.getTargetLink()).targetId((String)in.getTargetId().orNull()).clientOperationId((String)in.getClientOperationId().orNull()).status(in.getStatus()).statusMessage((String)in.getStatusMessage().orNull()).user(in.getUser()).progress((Integer)in.getProgress().get()).insertTime(in.getInsertTime()).startTime((Date)in.getStartTime().orNull()).endTime((Date)in.getEndTime().orNull()).httpErrorStatusCode(in.getHttpError().isPresent() ? Integer.valueOf(((HttpResponse)in.getHttpError().get()).getStatusCode()) : null).httpErrorMessage(in.getHttpError().isPresent() ? ((HttpResponse)in.getHttpError().get()).getMessage() : null).operationType(in.getOperationType()).errors(in.getErrors()).zone((URI)in.getZone().orNull()).region((URI)in.getRegion().orNull());
        }
    }

    public static enum Status {
        PENDING,
        RUNNING,
        DONE;

    }
}

