/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.googlecomputeengine.domain;

import com.google.common.annotations.Beta;
import com.google.common.base.Objects;
import com.google.common.base.Preconditions;
import java.net.URI;
import java.util.Date;
import org.jclouds.googlecomputeengine.domain.Resource;

@Beta
public abstract class AbstractDisk
extends Resource {
    protected final Integer sizeGb;
    protected final String status;

    protected AbstractDisk(Resource.Kind kind, String id, Date creationTimestamp, URI selfLink, String name, String description, Integer sizeGb, String status) {
        super(kind, id, creationTimestamp, selfLink, name, description);
        this.sizeGb = (Integer)Preconditions.checkNotNull((Object)sizeGb, (String)"sizeGb of %s", (Object[])new Object[]{name});
        this.status = (String)Preconditions.checkNotNull((Object)status, (String)"status of %s", (Object[])new Object[]{name});
    }

    public int getSizeGb() {
        return this.sizeGb;
    }

    public String getStatus() {
        return this.status;
    }

    @Override
    protected Objects.ToStringHelper string() {
        return super.string().omitNullValues().add("sizeGb", (Object)this.sizeGb).add("status", (Object)this.status);
    }

    @Override
    public String toString() {
        return this.string().toString();
    }

    public static Builder<?> builder() {
        return new ConcreteBuilder();
    }

    public Builder<?> toBuilder() {
        return new ConcreteBuilder().fromAbstractDisk(this);
    }

    private static class ConcreteBuilder
    extends Builder<ConcreteBuilder> {
        private ConcreteBuilder() {
        }

        @Override
        protected ConcreteBuilder self() {
            return this;
        }
    }

    public static abstract class Builder<T extends Builder<T>>
    extends Resource.Builder<T> {
        protected Integer sizeGb;
        protected String status;

        public T sizeGb(Integer sizeGb) {
            this.sizeGb = sizeGb;
            return (T)((Builder)this.self());
        }

        public T status(String status) {
            this.status = status;
            return (T)((Builder)this.self());
        }

        public T fromAbstractDisk(AbstractDisk in) {
            return ((Builder)((Builder)super.fromResource(in)).sizeGb(in.getSizeGb())).status(in.getStatus());
        }
    }
}

