/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.googlecomputeengine.compute.functions;

import com.google.common.base.Predicate;
import javax.inject.Inject;
import org.jclouds.compute.functions.GroupNamingConvention;

public class FirewallTagNamingConvention {
    private final String sharedResourceName;

    public FirewallTagNamingConvention(String sharedResourceName) {
        this.sharedResourceName = sharedResourceName;
    }

    public String name(int port) {
        return String.format("%s-port-%s", this.sharedResourceName, port);
    }

    public Predicate<? super String> isFirewallTag() {
        return new Predicate<String>(){

            public boolean apply(String input) {
                return input != null && input.startsWith(FirewallTagNamingConvention.this.sharedResourceName + "-port-");
            }
        };
    }

    public static class Factory {
        private final GroupNamingConvention.Factory namingConvention;

        @Inject
        public Factory(GroupNamingConvention.Factory namingConvention) {
            this.namingConvention = namingConvention;
        }

        public FirewallTagNamingConvention get(String groupName) {
            return new FirewallTagNamingConvention(this.namingConvention.create().sharedNameForGroup(groupName));
        }
    }
}

