/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.googlecomputeengine.compute;

import com.google.common.base.Function;
import com.google.common.base.Objects;
import com.google.common.base.Optional;
import com.google.common.base.Preconditions;
import com.google.common.base.Predicate;
import com.google.common.base.Supplier;
import com.google.common.collect.FluentIterable;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.google.common.primitives.Ints;
import com.google.common.util.concurrent.Atomics;
import com.google.common.util.concurrent.UncheckedTimeoutException;
import com.google.inject.Inject;
import java.net.URI;
import java.util.ArrayList;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicReference;
import javax.annotation.Resource;
import javax.inject.Named;
import org.jclouds.collect.Memoized;
import org.jclouds.compute.ComputeServiceAdapter;
import org.jclouds.compute.domain.Hardware;
import org.jclouds.compute.domain.Template;
import org.jclouds.compute.options.TemplateOptions;
import org.jclouds.domain.Location;
import org.jclouds.domain.LoginCredentials;
import org.jclouds.googlecomputeengine.GoogleComputeEngineApi;
import org.jclouds.googlecomputeengine.compute.functions.FirewallTagNamingConvention;
import org.jclouds.googlecomputeengine.compute.options.GoogleComputeEngineTemplateOptions;
import org.jclouds.googlecomputeengine.config.UserProject;
import org.jclouds.googlecomputeengine.domain.Disk;
import org.jclouds.googlecomputeengine.domain.Image;
import org.jclouds.googlecomputeengine.domain.Instance;
import org.jclouds.googlecomputeengine.domain.InstanceInZone;
import org.jclouds.googlecomputeengine.domain.InstanceTemplate;
import org.jclouds.googlecomputeengine.domain.MachineType;
import org.jclouds.googlecomputeengine.domain.MachineTypeInZone;
import org.jclouds.googlecomputeengine.domain.Operation;
import org.jclouds.googlecomputeengine.domain.SlashEncodedIds;
import org.jclouds.googlecomputeengine.domain.Zone;
import org.jclouds.googlecomputeengine.features.InstanceApi;
import org.jclouds.googlecomputeengine.predicates.InstancePredicates;
import org.jclouds.http.HttpResponse;
import org.jclouds.logging.Logger;
import org.jclouds.util.Predicates2;

public class GoogleComputeEngineServiceAdapter
implements ComputeServiceAdapter<InstanceInZone, MachineTypeInZone, Image, Zone> {
    @Resource
    @Named(value="jclouds.compute")
    protected Logger logger = Logger.NULL;
    private final GoogleComputeEngineApi api;
    private final Supplier<String> userProject;
    private final Supplier<Map<URI, ? extends Location>> zones;
    private final Function<TemplateOptions, ImmutableMap.Builder<String, String>> metatadaFromTemplateOptions;
    private final Predicate<AtomicReference<Operation>> retryOperationDonePredicate;
    private final long operationCompleteCheckInterval;
    private final long operationCompleteCheckTimeout;
    private final FirewallTagNamingConvention.Factory firewallTagNamingConvention;

    @Inject
    public GoogleComputeEngineServiceAdapter(GoogleComputeEngineApi api, @UserProject Supplier<String> userProject, Function<TemplateOptions, ImmutableMap.Builder<String, String>> metatadaFromTemplateOptions, @Named(value="zone") Predicate<AtomicReference<Operation>> operationDonePredicate, @Named(value="jclouds.google-compute-engine.operation-complete-interval") Long operationCompleteCheckInterval, @Named(value="jclouds.google-compute-engine.operation-complete-timeout") Long operationCompleteCheckTimeout, @Memoized Supplier<Map<URI, ? extends Location>> zones, FirewallTagNamingConvention.Factory firewallTagNamingConvention) {
        this.api = (GoogleComputeEngineApi)Preconditions.checkNotNull((Object)api, (Object)"google compute api");
        this.userProject = (Supplier)Preconditions.checkNotNull(userProject, (Object)"user project name");
        this.metatadaFromTemplateOptions = (Function)Preconditions.checkNotNull(metatadaFromTemplateOptions, (Object)"metadata from template options function");
        this.operationCompleteCheckInterval = (Long)Preconditions.checkNotNull((Object)operationCompleteCheckInterval, (Object)"operation completed check interval");
        this.operationCompleteCheckTimeout = (Long)Preconditions.checkNotNull((Object)operationCompleteCheckTimeout, (Object)"operation completed check timeout");
        this.retryOperationDonePredicate = Predicates2.retry(operationDonePredicate, (long)operationCompleteCheckTimeout, (long)operationCompleteCheckInterval, (TimeUnit)TimeUnit.MILLISECONDS);
        this.zones = (Supplier)Preconditions.checkNotNull(zones, (Object)"zones");
        this.firewallTagNamingConvention = (FirewallTagNamingConvention.Factory)Preconditions.checkNotNull((Object)firewallTagNamingConvention, (Object)"firewallTagNamingConvention");
    }

    public ComputeServiceAdapter.NodeAndInitialCredentials<InstanceInZone> createNodeWithGroupEncodedIntoName(String group, final String name, Template template) {
        Preconditions.checkNotNull((Object)template, (Object)"template");
        GoogleComputeEngineTemplateOptions options = ((GoogleComputeEngineTemplateOptions)((Object)GoogleComputeEngineTemplateOptions.class.cast(template.getOptions()))).clone();
        Preconditions.checkState((boolean)options.getNetwork().isPresent(), (Object)"network was not present in template options");
        Hardware hardware = (Hardware)Preconditions.checkNotNull((Object)template.getHardware(), (Object)"hardware must be set");
        Preconditions.checkNotNull((Object)hardware.getUri(), (Object)"hardware must have a URI");
        Preconditions.checkNotNull((Object)template.getImage().getUri(), (Object)"image URI is null");
        ArrayList disks = Lists.newArrayList();
        if (!Iterables.tryFind(options.getDisks(), InstancePredicates.isBootDisk()).isPresent()) {
            Disk bootDisk = this.createBootDisk(template, name);
            disks.add(new InstanceTemplate.PersistentDisk(InstanceTemplate.PersistentDisk.Mode.READ_WRITE, bootDisk.getSelfLink(), null, true, true));
        }
        disks.addAll(options.getDisks());
        InstanceTemplate instanceTemplate = InstanceTemplate.builder().forMachineType(hardware.getUri());
        if (options.isEnableNat()) {
            instanceTemplate.addNetworkInterface((URI)options.getNetwork().get(), Instance.NetworkInterface.AccessConfig.Type.ONE_TO_ONE_NAT);
        } else {
            instanceTemplate.addNetworkInterface((URI)options.getNetwork().get());
        }
        instanceTemplate.disks(disks);
        LoginCredentials credentials = this.getFromImageAndOverrideIfRequired(template.getImage(), options);
        ImmutableMap.Builder metadataBuilder = (ImmutableMap.Builder)this.metatadaFromTemplateOptions.apply((Object)options);
        metadataBuilder.put((Object)"jclouds-image", (Object)template.getImage().getUri().toString());
        if (!options.shouldKeepBootDisk()) {
            metadataBuilder.put((Object)"jclouds-delete-boot-disk", (Object)Boolean.TRUE.toString());
        }
        instanceTemplate.metadata((Map<String, String>)metadataBuilder.build());
        instanceTemplate.serviceAccounts(options.getServiceAccounts());
        final InstanceApi instanceApi = this.api.getInstanceApiForProject((String)this.userProject.get());
        final String zone = template.getLocation().getId();
        Operation operation = instanceApi.createInZone(name, zone, instanceTemplate);
        if (options.shouldBlockUntilRunning()) {
            this.waitOperationDone(operation);
        }
        AtomicReference instance = Atomics.newReference();
        Predicates2.retry((Predicate)new Predicate<AtomicReference<Instance>>(){

            public boolean apply(AtomicReference<Instance> input) {
                input.set(instanceApi.getInZone(zone, name));
                return input.get() != null;
            }
        }, (long)this.operationCompleteCheckTimeout, (long)this.operationCompleteCheckInterval, (TimeUnit)TimeUnit.MILLISECONDS).apply((Object)instance);
        if (!options.getTags().isEmpty()) {
            Operation tagsOperation = instanceApi.setTagsInZone(zone, name, options.getTags(), ((Instance)instance.get()).getTags().getFingerprint());
            this.waitOperationDone(tagsOperation);
            Predicates2.retry((Predicate)new Predicate<AtomicReference<Instance>>(){

                public boolean apply(AtomicReference<Instance> input) {
                    input.set(instanceApi.getInZone(zone, name));
                    return input.get() != null;
                }
            }, (long)this.operationCompleteCheckTimeout, (long)this.operationCompleteCheckInterval, (TimeUnit)TimeUnit.MILLISECONDS).apply((Object)instance);
        }
        final FirewallTagNamingConvention naming = this.firewallTagNamingConvention.get(group);
        ImmutableSet tags = FluentIterable.from((Iterable)Ints.asList((int[])options.getInboundPorts())).transform((Function)new Function<Integer, String>(){

            public String apply(Integer input) {
                return input != null ? naming.name(input) : null;
            }
        }).toSet();
        instanceApi.setTagsInZone(zone, ((Instance)instance.get()).getName(), (Set<String>)tags, ((Instance)instance.get()).getTags().getFingerprint());
        InstanceInZone instanceInZone = new InstanceInZone((Instance)instance.get(), zone);
        return new ComputeServiceAdapter.NodeAndInitialCredentials((Object)instanceInZone, instanceInZone.slashEncode(), credentials);
    }

    private Disk createBootDisk(Template template, String instanceName) {
        URI imageUri = template.getImage().getUri();
        GoogleComputeEngineTemplateOptions options = ((GoogleComputeEngineTemplateOptions)((Object)GoogleComputeEngineTemplateOptions.class.cast(template.getOptions()))).clone();
        int diskSize = ((Long)options.getBootDiskSize().or((Object)10L)).intValue();
        String diskName = instanceName + "-" + "boot-disk";
        Operation diskOperation = this.api.getDiskApiForProject((String)this.userProject.get()).createFromImageWithSizeInZone(imageUri.toString(), diskName, diskSize, template.getLocation().getId());
        this.waitOperationDone(diskOperation);
        return this.api.getDiskApiForProject((String)this.userProject.get()).getInZone(template.getLocation().getId(), diskName);
    }

    public Iterable<MachineTypeInZone> listHardwareProfiles() {
        ImmutableSet.Builder builder = ImmutableSet.builder();
        for (Location zone : ((Map)this.zones.get()).values()) {
            builder.addAll((Iterable)this.api.getMachineTypeApiForProject((String)this.userProject.get()).listInZone(zone.getId()).concat().filter((Predicate)new Predicate<MachineType>(){

                public boolean apply(MachineType input) {
                    return !input.getDeprecated().isPresent();
                }
            }).transform((Function)new Function<MachineType, MachineTypeInZone>(){

                public MachineTypeInZone apply(MachineType arg0) {
                    return new MachineTypeInZone(arg0, arg0.getZone());
                }
            }));
        }
        return builder.build();
    }

    public Iterable<Image> listImages() {
        return ImmutableSet.builder().addAll((Iterable)this.api.getImageApiForProject((String)this.userProject.get()).list().concat()).addAll((Iterable)this.api.getImageApiForProject("debian-cloud").list().concat()).addAll((Iterable)this.api.getImageApiForProject("centos-cloud").list().concat()).build();
    }

    public Image getImage(String id) {
        return (Image)Objects.firstNonNull((Object)this.api.getImageApiForProject((String)this.userProject.get()).get(id), (Object)Objects.firstNonNull((Object)this.api.getImageApiForProject("debian-cloud").get(id), (Object)this.api.getImageApiForProject("centos-cloud").get(id)));
    }

    public Iterable<Zone> listLocations() {
        return this.api.getZoneApiForProject((String)this.userProject.get()).list().concat();
    }

    public InstanceInZone getNode(String name) {
        SlashEncodedIds slashEncodedIds = SlashEncodedIds.fromSlashEncoded(name);
        Instance instance = this.api.getInstanceApiForProject((String)this.userProject.get()).getInZone(slashEncodedIds.getFirstId(), slashEncodedIds.getSecondId());
        return instance == null ? null : new InstanceInZone(instance, slashEncodedIds.getFirstId());
    }

    public Iterable<InstanceInZone> listNodes() {
        return FluentIterable.from(((Map)this.zones.get()).values()).transformAndConcat((Function)new Function<Location, ImmutableSet<InstanceInZone>>(){

            public ImmutableSet<InstanceInZone> apply(final Location input) {
                return GoogleComputeEngineServiceAdapter.this.api.getInstanceApiForProject((String)GoogleComputeEngineServiceAdapter.this.userProject.get()).listInZone(input.getId()).concat().transform((Function)new Function<Instance, InstanceInZone>(){

                    public InstanceInZone apply(Instance arg0) {
                        return new InstanceInZone(arg0, input.getId());
                    }
                }).toSet();
            }
        }).toSet();
    }

    public Iterable<InstanceInZone> listNodesByIds(final Iterable<String> ids) {
        return Iterables.filter(this.listNodes(), (Predicate)new Predicate<InstanceInZone>(){

            public boolean apply(InstanceInZone instanceInZone) {
                return Iterables.contains((Iterable)ids, (Object)instanceInZone.getInstance().getName());
            }
        });
    }

    public void destroyNode(String name) {
        SlashEncodedIds slashEncodedIds = SlashEncodedIds.fromSlashEncoded(name);
        String diskName = null;
        try {
            Optional disk;
            Instance instance = this.api.getInstanceApiForProject((String)this.userProject.get()).getInZone(slashEncodedIds.getFirstId(), slashEncodedIds.getSecondId());
            if (instance.getMetadata().getItems().get("jclouds-delete-boot-disk").equals("true") && (disk = Iterables.tryFind(instance.getDisks(), (Predicate)new Predicate<Instance.AttachedDisk>(){

                public boolean apply(Instance.AttachedDisk input) {
                    return Instance.PersistentAttachedDisk.class.isInstance(input) && ((Instance.PersistentAttachedDisk)Instance.PersistentAttachedDisk.class.cast(input)).isBoot();
                }
            })).isPresent()) {
                diskName = ((Instance.PersistentAttachedDisk)Instance.PersistentAttachedDisk.class.cast(disk.get())).getSourceDiskName();
            }
        }
        catch (Exception e) {
            // empty catch block
        }
        this.waitOperationDone(this.api.getInstanceApiForProject((String)this.userProject.get()).deleteInZone(slashEncodedIds.getFirstId(), slashEncodedIds.getSecondId()));
        if (diskName != null) {
            this.waitOperationDone(this.api.getDiskApiForProject((String)this.userProject.get()).deleteInZone(slashEncodedIds.getFirstId(), diskName));
        }
    }

    public void rebootNode(String name) {
        SlashEncodedIds slashEncodedIds = SlashEncodedIds.fromSlashEncoded(name);
        this.waitOperationDone(this.api.getInstanceApiForProject((String)this.userProject.get()).resetInZone(slashEncodedIds.getFirstId(), slashEncodedIds.getSecondId()));
    }

    public void resumeNode(String name) {
        throw new UnsupportedOperationException("resume is not supported by GCE");
    }

    public void suspendNode(String name) {
        throw new UnsupportedOperationException("suspend is not supported by GCE");
    }

    private LoginCredentials getFromImageAndOverrideIfRequired(org.jclouds.compute.domain.Image image, GoogleComputeEngineTemplateOptions options) {
        LoginCredentials defaultCredentials = image.getDefaultCredentials();
        String[] keys = defaultCredentials.getPrivateKey().split(":");
        String publicKey = keys[0];
        String privateKey = keys[1];
        LoginCredentials.Builder credentialsBuilder = defaultCredentials.toBuilder();
        credentialsBuilder.privateKey(privateKey);
        if (options.getPublicKey() == null) {
            options.authorizePublicKey(publicKey);
        }
        if (options.hasLoginPrivateKeyOption()) {
            credentialsBuilder.privateKey(options.getPrivateKey());
        }
        if (options.getLoginUser() != null) {
            credentialsBuilder.identity(options.getLoginUser());
        }
        if (options.hasLoginPasswordOption()) {
            credentialsBuilder.password(options.getLoginPassword());
        }
        if (options.shouldAuthenticateSudo() != null) {
            credentialsBuilder.authenticateSudo(options.shouldAuthenticateSudo().booleanValue());
        }
        LoginCredentials credentials = credentialsBuilder.build();
        options.overrideLoginCredentials(credentials);
        return credentials;
    }

    private void waitOperationDone(Operation operation) {
        AtomicReference operationRef = Atomics.newReference((Object)operation);
        if (!this.retryOperationDonePredicate.apply((Object)operationRef)) {
            throw new UncheckedTimeoutException("operation did not reach DONE state" + operationRef.get());
        }
        if (((Operation)operationRef.get()).getHttpError().isPresent()) {
            HttpResponse response = (HttpResponse)((Operation)operationRef.get()).getHttpError().get();
            throw new IllegalStateException("operation failed. Http Error Code: " + response.getStatusCode() + " HttpError: " + response.getMessage());
        }
    }
}

