/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.sshj;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.MoreObjects;
import com.google.common.base.Objects;
import com.google.common.base.Optional;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.net.HostAndPort;
import com.jcraft.jsch.agentproxy.AgentProxy;
import com.jcraft.jsch.agentproxy.Connector;
import com.jcraft.jsch.agentproxy.Identity;
import com.jcraft.jsch.agentproxy.sshj.AuthAgent;
import jakarta.annotation.Resource;
import jakarta.inject.Named;
import java.io.IOException;
import java.util.List;
import net.schmizz.sshj.SSHClient;
import net.schmizz.sshj.common.Buffer;
import net.schmizz.sshj.transport.verification.HostKeyVerifier;
import net.schmizz.sshj.transport.verification.PromiscuousVerifier;
import net.schmizz.sshj.userauth.keyprovider.KeyProvider;
import net.schmizz.sshj.userauth.keyprovider.OpenSSHKeyFile;
import net.schmizz.sshj.userauth.method.AuthMethod;
import org.jclouds.domain.LoginCredentials;
import org.jclouds.logging.Logger;
import org.jclouds.sshj.SshjSshClient;

public class SSHClientConnection
implements SshjSshClient.Connection<SSHClient> {
    private Optional<Connector> agentConnector;
    @Resource
    @Named(value="jclouds.ssh")
    protected Logger logger = Logger.NULL;
    private final HostAndPort hostAndPort;
    private final LoginCredentials loginCredentials;
    private final int connectTimeout;
    private final int sessionTimeout;
    @VisibleForTesting
    transient SSHClient ssh;

    public static Builder builder() {
        return new Builder();
    }

    private SSHClientConnection(HostAndPort hostAndPort, LoginCredentials loginCredentials, int connectTimeout, int sessionTimeout, Optional<Connector> agentConnector) {
        this.hostAndPort = (HostAndPort)Preconditions.checkNotNull((Object)hostAndPort, (Object)"hostAndPort");
        this.loginCredentials = (LoginCredentials)Preconditions.checkNotNull((Object)loginCredentials, (String)"loginCredentials for %", (Object)hostAndPort);
        this.connectTimeout = connectTimeout;
        this.sessionTimeout = sessionTimeout;
        this.agentConnector = (Optional)Preconditions.checkNotNull(agentConnector, (String)"agentConnector for %", (Object)hostAndPort);
    }

    @Override
    public void clear() {
        if (this.ssh != null && this.ssh.isConnected()) {
            try {
                this.ssh.disconnect();
            }
            catch (AssertionError assertionError) {
            }
            catch (IOException e) {
                this.logger.debug("<< exception disconnecting from %s: %s", new Object[]{e, e.getMessage()});
            }
            this.ssh = null;
        }
    }

    @Override
    public SSHClient create() throws Exception {
        this.ssh = new SSHClient();
        this.ssh.addHostKeyVerifier((HostKeyVerifier)new PromiscuousVerifier());
        if (this.connectTimeout != 0) {
            this.ssh.setConnectTimeout(this.connectTimeout);
        }
        if (this.sessionTimeout != 0) {
            this.ssh.setTimeout(this.sessionTimeout);
        }
        this.ssh.connect(this.hostAndPort.getHost(), this.hostAndPort.getPortOrDefault(22));
        if (this.loginCredentials.hasUnencryptedPrivateKey()) {
            OpenSSHKeyFile key = new OpenSSHKeyFile();
            key.init((String)this.loginCredentials.getOptionalPrivateKey().get(), null);
            this.ssh.authPublickey(this.loginCredentials.getUser(), new KeyProvider[]{key});
        } else if (this.loginCredentials.getOptionalPassword().isPresent()) {
            this.ssh.authPassword(this.loginCredentials.getUser(), (String)this.loginCredentials.getOptionalPassword().get());
        } else if (this.agentConnector.isPresent()) {
            AgentProxy proxy = new AgentProxy((Connector)this.agentConnector.get());
            this.ssh.auth(this.loginCredentials.getUser(), SSHClientConnection.getAuthMethods(proxy));
        }
        return this.ssh;
    }

    public HostAndPort getHostAndPort() {
        return this.hostAndPort;
    }

    public LoginCredentials getLoginCredentials() {
        return this.loginCredentials;
    }

    public int getConnectTimeout() {
        return this.connectTimeout;
    }

    public int getSessionTimeout() {
        return this.sessionTimeout;
    }

    public Optional<Connector> getAgentConnector() {
        return this.agentConnector;
    }

    public SSHClient getSSHClient() {
        return this.ssh;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        SSHClientConnection that = (SSHClientConnection)SSHClientConnection.class.cast(o);
        return Objects.equal((Object)this.hostAndPort, (Object)that.hostAndPort) && Objects.equal((Object)this.loginCredentials, (Object)that.loginCredentials) && Objects.equal((Object)this.ssh, (Object)that.ssh);
    }

    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{this.hostAndPort, this.loginCredentials, this.ssh});
    }

    public String toString() {
        return MoreObjects.toStringHelper((String)"").add("hostAndPort", (Object)this.hostAndPort).add("loginUser", (Object)this.loginCredentials.getUser()).add("ssh", this.ssh != null ? Integer.valueOf(this.ssh.hashCode()) : null).add("connectTimeout", this.connectTimeout).add("sessionTimeout", this.sessionTimeout).toString();
    }

    private static List<AuthMethod> getAuthMethods(AgentProxy agent) throws Buffer.BufferException {
        ImmutableList.Builder identities = ImmutableList.builder();
        for (Identity identity : agent.getIdentities()) {
            identities.add((Object)new AuthAgent(agent, identity));
        }
        return identities.build();
    }

    public static class Builder {
        protected HostAndPort hostAndPort;
        protected LoginCredentials loginCredentials;
        protected int connectTimeout;
        protected int sessionTimeout;
        protected Optional<Connector> agentConnector;

        public Builder hostAndPort(HostAndPort hostAndPort) {
            this.hostAndPort = hostAndPort;
            return this;
        }

        public Builder loginCredentials(LoginCredentials loginCredentials) {
            this.loginCredentials = loginCredentials;
            return this;
        }

        public Builder connectTimeout(int connectTimeout) {
            this.connectTimeout = connectTimeout;
            return this;
        }

        public Builder sessionTimeout(int sessionTimeout) {
            this.sessionTimeout = sessionTimeout;
            return this;
        }

        public Builder agentConnector(Optional<Connector> agentConnector) {
            this.agentConnector = agentConnector;
            return this;
        }

        public SSHClientConnection build() {
            return new SSHClientConnection(this.hostAndPort, this.loginCredentials, this.connectTimeout, this.sessionTimeout, this.agentConnector);
        }

        protected Builder fromSSHClientConnection(SSHClientConnection in) {
            return this.hostAndPort(in.getHostAndPort()).connectTimeout(in.getConnectTimeout()).loginCredentials(in.getLoginCredentials()).sessionTimeout(in.getSessionTimeout()).agentConnector(in.getAgentConnector());
        }
    }
}

