/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.aws.binders;

import com.google.common.base.Function;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Maps;
import com.google.common.collect.Multimap;
import com.google.common.collect.Multimaps;
import com.google.common.collect.SetMultimap;
import java.util.Map;
import org.jclouds.http.HttpRequest;
import org.jclouds.rest.Binder;

public class BindMapToIndexedFormParams
implements Binder {
    private final String keyPattern;
    private final String valuePattern;

    protected BindMapToIndexedFormParams(String keyPattern, String valuePattern) {
        this.keyPattern = keyPattern;
        this.valuePattern = valuePattern;
    }

    public <R extends HttpRequest> R bindToRequest(R request, Object input) {
        if (Preconditions.checkNotNull((Object)input, (Object)"input") instanceof Iterable) {
            input = Maps.uniqueIndex((Iterable)((Iterable)input), (Function)new Function<String, String>(){
                int index = 1;

                public String apply(String input) {
                    return "" + this.index++;
                }
            });
        }
        Preconditions.checkArgument((boolean)(Preconditions.checkNotNull((Object)input, (Object)"input") instanceof Map), (Object)"this binder is only valid for Map");
        Map mapping = (Map)input;
        ImmutableMap.Builder builder = ImmutableMap.builder();
        int amazonOneBasedIndex = 1;
        for (Map.Entry entry : mapping.entrySet()) {
            builder.put((Object)String.format(this.keyPattern, amazonOneBasedIndex), (Object)((String)entry.getKey()));
            builder.put((Object)String.format(this.valuePattern, amazonOneBasedIndex), (Object)((String)entry.getValue()));
            ++amazonOneBasedIndex;
        }
        SetMultimap forms = Multimaps.forMap((Map)builder.build());
        return (R)(forms.isEmpty() ? request : request.toBuilder().replaceFormParams((Multimap)forms).build());
    }
}

