/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.openstack.nova.v2_0.predicates;

import com.google.common.base.Optional;
import com.google.common.base.Preconditions;
import com.google.common.base.Predicate;
import com.google.common.collect.FluentIterable;
import com.google.common.collect.Iterables;
import com.google.inject.Inject;
import jakarta.annotation.Resource;
import jakarta.inject.Singleton;
import java.util.NoSuchElementException;
import java.util.concurrent.atomic.AtomicReference;
import org.jclouds.logging.Logger;
import org.jclouds.openstack.nova.v2_0.NovaApi;
import org.jclouds.openstack.nova.v2_0.domain.SecurityGroup;
import org.jclouds.openstack.nova.v2_0.domain.regionscoped.RegionAndName;
import org.jclouds.openstack.nova.v2_0.domain.regionscoped.SecurityGroupInRegion;
import org.jclouds.openstack.nova.v2_0.extensions.SecurityGroupApi;
import org.jclouds.rest.ResourceNotFoundException;

@Singleton
public class FindSecurityGroupWithNameAndReturnTrue
implements Predicate<AtomicReference<RegionAndName>> {
    private final NovaApi novaApi;
    @Resource
    protected Logger logger = Logger.NULL;

    @Inject
    public FindSecurityGroupWithNameAndReturnTrue(NovaApi novaApi) {
        this.novaApi = (NovaApi)Preconditions.checkNotNull((Object)novaApi, (Object)"novaApi");
    }

    public boolean apply(AtomicReference<RegionAndName> securityGroupInRegionRef) {
        Preconditions.checkNotNull(securityGroupInRegionRef, (Object)"securityGroupRef");
        final RegionAndName securityGroupInRegion = (RegionAndName)Preconditions.checkNotNull((Object)securityGroupInRegionRef.get(), (Object)"securityGroupInRegion");
        Optional<SecurityGroupApi> api = this.novaApi.getSecurityGroupApi(securityGroupInRegion.getRegion());
        Preconditions.checkArgument((boolean)api.isPresent(), (Object)"Security groups are required, but the extension is not available!");
        this.logger.trace("looking for security group %s", new Object[]{securityGroupInRegion.slashEncode()});
        try {
            FluentIterable<SecurityGroup> allGroups = ((SecurityGroupApi)api.get()).list();
            SecurityGroup returnVal = (SecurityGroup)Iterables.find(allGroups, (Predicate)new Predicate<SecurityGroup>(){

                public boolean apply(SecurityGroup input) {
                    return input.getName().equals(securityGroupInRegion.getName());
                }
            });
            securityGroupInRegionRef.set(new SecurityGroupInRegion(returnVal, securityGroupInRegion.getRegion(), (Iterable<SecurityGroup>)allGroups));
            return true;
        }
        catch (ResourceNotFoundException e) {
            return false;
        }
        catch (NoSuchElementException e) {
            return false;
        }
    }
}

