/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.openstack.nova.v2_0.options;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Maps;
import jakarta.inject.Inject;
import java.util.HashMap;
import java.util.Map;
import org.jclouds.http.HttpRequest;
import org.jclouds.rest.MapBinder;
import org.jclouds.rest.binders.BindToJsonPayload;

public class RebuildServerOptions
implements MapBinder {
    @Inject
    private BindToJsonPayload jsonBinder;
    String imageRef;
    String name;
    String adminPass;
    String accessIPv4;
    String accessIPv6;

    public <R extends HttpRequest> R bindToRequest(R request, Map<String, Object> postParams) {
        HashMap image = Maps.newHashMap();
        if (this.imageRef != null) {
            image.put("imageRef", this.imageRef);
        }
        if (this.name != null) {
            image.put("name", this.name);
        }
        if (this.adminPass != null) {
            image.put("adminPass", this.adminPass);
        }
        if (this.accessIPv4 != null) {
            image.put("accessIPv4", this.accessIPv4);
        }
        if (this.accessIPv6 != null) {
            image.put("accessIPv6", this.accessIPv6);
        }
        return (R)this.jsonBinder.bindToRequest(request, (Map)ImmutableMap.of((Object)"rebuild", (Object)image));
    }

    public <R extends HttpRequest> R bindToRequest(R request, Object toBind) {
        throw new IllegalStateException("RebuildServer is a POST operation");
    }

    public RebuildServerOptions withImage(String ref) {
        Preconditions.checkNotNull((Object)ref, (Object)"image reference should not be null");
        Preconditions.checkArgument((!ref.isEmpty() ? 1 : 0) != 0, (Object)"image reference should not be empty");
        this.imageRef = ref;
        return this;
    }

    public RebuildServerOptions name(String name) {
        this.name = name;
        return this;
    }

    public RebuildServerOptions adminPass(String adminPass) {
        this.adminPass = adminPass;
        return this;
    }

    public RebuildServerOptions ipv4Address(String ipv4Address) {
        this.accessIPv4 = ipv4Address;
        return this;
    }

    public RebuildServerOptions ipv6Address(String iPv6Address) {
        this.accessIPv6 = iPv6Address;
        return this;
    }

    public static class Builder {
        public static RebuildServerOptions withImage(String ref) {
            RebuildServerOptions options = new RebuildServerOptions();
            return options.withImage(ref);
        }

        public static RebuildServerOptions name(String name) {
            RebuildServerOptions options = new RebuildServerOptions();
            return options.name(name);
        }

        public static RebuildServerOptions adminPass(String adminPass) {
            RebuildServerOptions options = new RebuildServerOptions();
            return options.adminPass(adminPass);
        }

        public static RebuildServerOptions ipv4Address(String ipv4Address) {
            RebuildServerOptions options = new RebuildServerOptions();
            return options.ipv4Address(ipv4Address);
        }

        public static RebuildServerOptions ipv6Address(String ipv6Address) {
            RebuildServerOptions options = new RebuildServerOptions();
            return options.ipv6Address(ipv6Address);
        }
    }
}

