/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.openstack.nova.v2_0.options;

import com.google.common.base.Preconditions;
import java.util.Date;
import org.jclouds.openstack.v2_0.options.PaginationOptions;

public class ListOptions
extends PaginationOptions {
    public static final ListOptions NONE = new ListOptions();

    public ListOptions withDetails() {
        this.pathSuffix = "/detail";
        return this;
    }

    public ListOptions limit(int limit) {
        super.limit(limit);
        return this;
    }

    public ListOptions marker(String marker) {
        super.marker(marker);
        return this;
    }

    public ListOptions changesSince(Date changesSince) {
        this.queryParameters.put((Object)"changes-since", (Object)("" + ((Date)Preconditions.checkNotNull((Object)changesSince, (Object)"changesSince")).getTime() / 1000L));
        return this;
    }

    public static class Builder {
        public static ListOptions withDetails() {
            ListOptions options = new ListOptions();
            return options.withDetails();
        }

        public static ListOptions marker(String marker) {
            ListOptions options = new ListOptions();
            return options.marker(marker);
        }

        public static ListOptions limit(int limit) {
            ListOptions options = new ListOptions();
            return options.limit(limit);
        }

        @Deprecated
        public static ListOptions maxResults(int maxKeys) {
            return Builder.limit(maxKeys);
        }

        public static ListOptions changesSince(Date since) {
            ListOptions options = new ListOptions();
            return options.changesSince(since);
        }
    }
}

