/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.openstack.nova.v2_0.functions.internal;

import com.google.common.annotations.Beta;
import com.google.common.base.Function;
import com.google.common.base.Optional;
import com.google.common.base.Preconditions;
import com.google.inject.TypeLiteral;
import jakarta.inject.Inject;
import jakarta.inject.Singleton;
import java.beans.ConstructorProperties;
import org.jclouds.collect.IterableWithMarker;
import org.jclouds.collect.internal.Arg0ToPagedIterable;
import org.jclouds.http.functions.ParseJson;
import org.jclouds.json.Json;
import org.jclouds.openstack.nova.v2_0.NovaApi;
import org.jclouds.openstack.nova.v2_0.domain.Server;
import org.jclouds.openstack.nova.v2_0.features.ServerApi;
import org.jclouds.openstack.v2_0.domain.Link;
import org.jclouds.openstack.v2_0.domain.PaginatedCollection;
import org.jclouds.openstack.v2_0.options.PaginationOptions;

@Singleton
@Beta
public class ParseServerDetails
extends ParseJson<Servers> {
    @Inject
    public ParseServerDetails(Json json) {
        super(json, TypeLiteral.get(Servers.class));
    }

    static class Servers
    extends PaginatedCollection<Server> {
        @ConstructorProperties(value={"servers", "servers_links"})
        protected Servers(Iterable<Server> servers, Iterable<Link> servers_links) {
            super(servers, servers_links);
        }
    }

    public static class ToPagedIterable
    extends Arg0ToPagedIterable.FromCaller<Server, ToPagedIterable> {
        private final NovaApi api;

        @Inject
        protected ToPagedIterable(NovaApi api) {
            this.api = (NovaApi)Preconditions.checkNotNull((Object)api, (Object)"api");
        }

        protected Function<Object, IterableWithMarker<Server>> markerToNextForArg0(Optional<Object> arg0) {
            String region = arg0.get().toString();
            final ServerApi serverApi = this.api.getServerApi(region);
            return new Function<Object, IterableWithMarker<Server>>(){

                public IterableWithMarker<Server> apply(Object input) {
                    PaginationOptions paginationOptions = (PaginationOptions)PaginationOptions.class.cast(input);
                    return (IterableWithMarker)IterableWithMarker.class.cast(serverApi.listInDetail(paginationOptions));
                }

                public String toString() {
                    return "listInDetail()";
                }
            };
        }
    }
}

