/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.openstack.nova.v2_0.extensions;

import com.google.common.annotations.Beta;
import jakarta.inject.Named;
import jakarta.ws.rs.Consumes;
import jakarta.ws.rs.POST;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.PathParam;
import jakarta.ws.rs.Produces;
import org.jclouds.fallbacks.MapHttp4xxCodesToExceptions;
import org.jclouds.openstack.keystone.auth.filters.AuthenticateRequest;
import org.jclouds.openstack.nova.v2_0.domain.BackupType;
import org.jclouds.openstack.nova.v2_0.functions.ParseImageIdFromLocationHeader;
import org.jclouds.openstack.nova.v2_0.options.CreateBackupOfServerOptions;
import org.jclouds.openstack.v2_0.services.Extension;
import org.jclouds.rest.annotations.Fallback;
import org.jclouds.rest.annotations.Payload;
import org.jclouds.rest.annotations.PayloadParam;
import org.jclouds.rest.annotations.RequestFilters;
import org.jclouds.rest.annotations.ResponseParser;
import org.jclouds.rest.annotations.WrapWith;

@Extension(of="compute", namespace="http://docs.openstack.org/ext/admin-actions/api/v1.1", name="AdminActions", alias="os-admin-actions")
@RequestFilters(value={AuthenticateRequest.class})
@Consumes(value={"application/json"})
@Path(value="/servers/{id}/action")
@Beta
public interface ServerAdminApi {
    @Named(value="serverAdmin:suspend")
    @POST
    @Produces(value={"application/json"})
    @Payload(value="{\"suspend\":null}")
    public void suspend(@PathParam(value="id") String var1);

    @Named(value="serverAdmin:resume")
    @POST
    @Produces(value={"application/json"})
    @Payload(value="{\"resume\":null}")
    public void resume(@PathParam(value="id") String var1);

    @Named(value="serverAdmin:migrate")
    @POST
    @Produces(value={"application/json"})
    @Payload(value="{\"migrate\":null}")
    public void migrate(@PathParam(value="id") String var1);

    @Named(value="serverAdmin:lock")
    @POST
    @Produces(value={"application/json"})
    @Payload(value="{\"lock\":null}")
    public void lock(@PathParam(value="id") String var1);

    @Named(value="serverAdmin:unlock")
    @POST
    @Produces(value={"application/json"})
    @Payload(value="{\"unlock\":null}")
    public void unlock(@PathParam(value="id") String var1);

    @Named(value="serverAdmin:resetNetwork")
    @POST
    @Produces(value={"application/json"})
    @Payload(value="{\"resetNetwork\":null}")
    public void resetNetwork(@PathParam(value="id") String var1);

    @Named(value="serverAdmin:createBackup")
    @POST
    @Produces(value={"application/json"})
    @WrapWith(value="createBackup")
    @ResponseParser(value=ParseImageIdFromLocationHeader.class)
    @Fallback(value=MapHttp4xxCodesToExceptions.class)
    public String createBackup(@PathParam(value="id") String var1, @PayloadParam(value="name") String var2, @PayloadParam(value="backup_type") BackupType var3, @PayloadParam(value="rotation") int var4, CreateBackupOfServerOptions ... var5);

    @Named(value="serverAdmin:pause")
    @POST
    @Produces(value={"application/json"})
    @Payload(value="{\"pause\":null}")
    public void pause(@PathParam(value="id") String var1);

    @Named(value="serverAdmin:unpause")
    @POST
    @Produces(value={"application/json"})
    @Payload(value="{\"unpause\":null}")
    public void unpause(@PathParam(value="id") String var1);

    @Named(value="serverAdmin:liveMigrate")
    @POST
    @Produces(value={"application/json"})
    @WrapWith(value="os-migrateLive")
    public void liveMigrate(@PathParam(value="id") String var1, @PayloadParam(value="host") String var2, @PayloadParam(value="block_migration") boolean var3, @PayloadParam(value="disk_over_commit") boolean var4);

    @Named(value="serverAdmin:injectNetwork")
    @POST
    @Produces(value={"application/json"})
    @Payload(value="{\"injectNetworkInfo\":null}")
    public void injectNetworkInfo(@PathParam(value="id") String var1);
}

