/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.openstack.nova.v2_0.extensions;

import com.google.common.annotations.Beta;
import com.google.common.collect.FluentIterable;
import jakarta.inject.Named;
import jakarta.ws.rs.Consumes;
import jakarta.ws.rs.GET;
import jakarta.ws.rs.PUT;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.PathParam;
import jakarta.ws.rs.Produces;
import org.jclouds.Fallbacks;
import org.jclouds.openstack.keystone.auth.filters.AuthenticateRequest;
import org.jclouds.openstack.nova.v2_0.domain.Host;
import org.jclouds.openstack.nova.v2_0.domain.HostResourceUsage;
import org.jclouds.openstack.nova.v2_0.functions.FieldValueResponseParsers;
import org.jclouds.openstack.v2_0.services.Extension;
import org.jclouds.rest.annotations.Fallback;
import org.jclouds.rest.annotations.Payload;
import org.jclouds.rest.annotations.RequestFilters;
import org.jclouds.rest.annotations.ResponseParser;
import org.jclouds.rest.annotations.SelectJson;

@Extension(of="compute", namespace="http://docs.openstack.org/ext/hosts/api/v1.1", name="Hosts", alias="os-hosts")
@RequestFilters(value={AuthenticateRequest.class})
@Consumes(value={"application/json"})
@Path(value="/os-hosts")
@Beta
public interface HostAdministrationApi {
    @Named(value="hostAdmin:list")
    @GET
    @SelectJson(value={"hosts"})
    @Fallback(value=Fallbacks.EmptyFluentIterableOnNotFoundOr404.class)
    public FluentIterable<Host> list();

    @Named(value="hostAdmin:listResourceUsage")
    @GET
    @Path(value="/{id}")
    @SelectJson(value={"host"})
    @Fallback(value=Fallbacks.EmptyFluentIterableOnNotFoundOr404.class)
    public FluentIterable<HostResourceUsage> listResourceUsage(@PathParam(value="id") String var1);

    @Named(value="hostAdmin:enable")
    @PUT
    @Path(value="/{id}")
    @Produces(value={"application/json"})
    @Payload(value="{\"status\":\"enable\"}")
    @ResponseParser(value=FieldValueResponseParsers.StatusEnabledResponseParser.class)
    public boolean enable(@PathParam(value="id") String var1);

    @Named(value="hostAdmin:disable")
    @PUT
    @Path(value="/{id}")
    @Produces(value={"application/json"})
    @Payload(value="{\"status\":\"disable\"}")
    @ResponseParser(value=FieldValueResponseParsers.StatusDisabledResponseParser.class)
    public boolean disable(@PathParam(value="id") String var1);

    @Named(value="hostAdmin:startMaintenance")
    @PUT
    @Path(value="/{id}")
    @Produces(value={"application/json"})
    @Payload(value="{\"maintenance_mode\":\"enable\"}")
    @ResponseParser(value=FieldValueResponseParsers.MaintenanceModeEnabledResponseParser.class)
    public boolean startMaintenance(@PathParam(value="id") String var1);

    @Named(value="hostAdmin:stopMaintenance")
    @PUT
    @Path(value="/{id}")
    @Produces(value={"application/json"})
    @Payload(value="{\"maintenance_mode\":\"disable\"}")
    @ResponseParser(value=FieldValueResponseParsers.MaintenanceModeDisabledResponseParser.class)
    public boolean stopMaintenance(@PathParam(value="id") String var1);

    @Named(value="hostAdmin:startup")
    @GET
    @Path(value="/{id}/startup")
    @ResponseParser(value=FieldValueResponseParsers.PowerIsStartupResponseParser.class)
    public boolean startup(@PathParam(value="id") String var1);

    @Named(value="hostAdmin:shutdown")
    @GET
    @Path(value="/{id}/shutdown")
    @ResponseParser(value=FieldValueResponseParsers.PowerIsShutdownResponseParser.class)
    public boolean shutdown(@PathParam(value="id") String var1);

    @Named(value="hostAdmin:reboot")
    @GET
    @Path(value="/{id}/reboot")
    @ResponseParser(value=FieldValueResponseParsers.PowerIsRebootResponseParser.class)
    public boolean reboot(@PathParam(value="id") String var1);
}

