/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.openstack.nova.v2_0.extensions;

import com.google.common.annotations.Beta;
import com.google.common.collect.FluentIterable;
import jakarta.inject.Named;
import jakarta.ws.rs.Consumes;
import jakarta.ws.rs.DELETE;
import jakarta.ws.rs.GET;
import jakarta.ws.rs.POST;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.PathParam;
import jakarta.ws.rs.Produces;
import org.jclouds.Fallbacks;
import org.jclouds.javax.annotation.Nullable;
import org.jclouds.openstack.keystone.auth.filters.AuthenticateRequest;
import org.jclouds.openstack.nova.v2_0.domain.InterfaceAttachment;
import org.jclouds.openstack.v2_0.services.Extension;
import org.jclouds.rest.annotations.Fallback;
import org.jclouds.rest.annotations.Payload;
import org.jclouds.rest.annotations.PayloadParam;
import org.jclouds.rest.annotations.RequestFilters;
import org.jclouds.rest.annotations.SelectJson;

@Extension(of="compute", namespace="http://docs.openstack.org/compute/ext/interfaces/api/v1.1", name="AttachInterfaces", alias="os-attach-interfaces")
@RequestFilters(value={AuthenticateRequest.class})
@Consumes(value={"application/json"})
@Path(value="/servers")
@Beta
public interface AttachInterfaceApi {
    @Named(value="attachInterface:list")
    @GET
    @Path(value="/{serverId}/os-interface")
    @SelectJson(value={"interfaceAttachments"})
    @Fallback(value=Fallbacks.EmptyFluentIterableOnNotFoundOr404.class)
    public FluentIterable<InterfaceAttachment> list(@PathParam(value="serverId") String var1);

    @Named(value="attachInterface:get")
    @GET
    @Path(value="/{serverId}/os-interface/{attachmentId}")
    @SelectJson(value={"interfaceAttachment"})
    @Fallback(value=Fallbacks.NullOnNotFoundOr404.class)
    @Nullable
    public InterfaceAttachment get(@PathParam(value="serverId") String var1, @PathParam(value="attachmentId") String var2);

    @Named(value="attachInterface:create")
    @POST
    @Path(value="/{serverId}/os-interface")
    @SelectJson(value={"interfaceAttachment"})
    @Payload(value="%7B\"interfaceAttachment\":%7B\"port_id\":\"{portId}\"%7D%7D")
    @Produces(value={"application/json"})
    public InterfaceAttachment create(@PathParam(value="serverId") String var1, @PayloadParam(value="portId") String var2);

    @Named(value="attachInterface:delete")
    @DELETE
    @Path(value="/{serverId}/os-interface/{attachmentId}")
    @Fallback(value=Fallbacks.FalseOnNotFoundOr404.class)
    public boolean delete(@PathParam(value="serverId") String var1, @PathParam(value="attachmentId") String var2);
}

