/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.openstack.nova.v2_0.domain;

import com.google.common.base.MoreObjects;
import com.google.common.base.Objects;
import com.google.common.base.Preconditions;
import jakarta.inject.Named;
import java.beans.ConstructorProperties;

public class Quota {
    private final String id;
    @Named(value="metadata_items")
    private final int metadataItems;
    @Named(value="injected_file_content_bytes")
    private final int injectedFileContentBytes;
    private final int volumes;
    private final int gigabytes;
    private final int ram;
    @Named(value="floating_ips")
    private final int floatingIps;
    private final int instances;
    @Named(value="injected_files")
    private final int injectedFiles;
    private final int cores;
    @Named(value="security_groups")
    private final int securityGroups;
    @Named(value="security_group_rules")
    private final int securityGroupRules;
    @Named(value="key_pairs")
    private final int keyPairs;

    public static Builder<?> builder() {
        return new ConcreteBuilder();
    }

    public Builder<?> toBuilder() {
        return new ConcreteBuilder().fromQuotas(this);
    }

    @ConstructorProperties(value={"id", "metadata_items", "injected_file_content_bytes", "volumes", "gigabytes", "ram", "floating_ips", "instances", "injected_files", "cores", "security_groups", "security_group_rules", "key_pairs"})
    protected Quota(String id, int metadataItems, int injectedFileContentBytes, int volumes, int gigabytes, int ram, int floatingIps, int instances, int injectedFiles, int cores, int securityGroups, int securityGroupRules, int keyPairs) {
        this.id = (String)Preconditions.checkNotNull((Object)id, (Object)"id");
        this.metadataItems = metadataItems;
        this.injectedFileContentBytes = injectedFileContentBytes;
        this.volumes = volumes;
        this.gigabytes = gigabytes;
        this.ram = ram;
        this.floatingIps = floatingIps;
        this.instances = instances;
        this.injectedFiles = injectedFiles;
        this.cores = cores;
        this.securityGroups = securityGroups;
        this.securityGroupRules = securityGroupRules;
        this.keyPairs = keyPairs;
    }

    public String getId() {
        return this.id;
    }

    public int getMetadatas() {
        return this.metadataItems;
    }

    public int getInjectedFileContentBytes() {
        return this.injectedFileContentBytes;
    }

    public int getVolumes() {
        return this.volumes;
    }

    public int getGigabytes() {
        return this.gigabytes;
    }

    public int getRam() {
        return this.ram;
    }

    public int getFloatingIps() {
        return this.floatingIps;
    }

    public int getInstances() {
        return this.instances;
    }

    public int getInjectedFiles() {
        return this.injectedFiles;
    }

    public int getCores() {
        return this.cores;
    }

    public int getSecurityGroups() {
        return this.securityGroups;
    }

    public int getSecurityGroupRules() {
        return this.securityGroupRules;
    }

    public int getKeyPairs() {
        return this.keyPairs;
    }

    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{this.id, this.metadataItems, this.injectedFileContentBytes, this.volumes, this.gigabytes, this.ram, this.floatingIps, this.instances, this.injectedFiles, this.cores, this.securityGroups, this.securityGroupRules, this.keyPairs});
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        Quota that = (Quota)Quota.class.cast(obj);
        return Objects.equal((Object)this.id, (Object)that.id) && Objects.equal((Object)this.metadataItems, (Object)that.metadataItems) && Objects.equal((Object)this.injectedFileContentBytes, (Object)that.injectedFileContentBytes) && Objects.equal((Object)this.volumes, (Object)that.volumes) && Objects.equal((Object)this.gigabytes, (Object)that.gigabytes) && Objects.equal((Object)this.ram, (Object)that.ram) && Objects.equal((Object)this.floatingIps, (Object)that.floatingIps) && Objects.equal((Object)this.instances, (Object)that.instances) && Objects.equal((Object)this.injectedFiles, (Object)that.injectedFiles) && Objects.equal((Object)this.cores, (Object)that.cores) && Objects.equal((Object)this.securityGroups, (Object)that.securityGroups) && Objects.equal((Object)this.securityGroupRules, (Object)that.securityGroupRules) && Objects.equal((Object)this.keyPairs, (Object)that.keyPairs);
    }

    protected MoreObjects.ToStringHelper string() {
        return MoreObjects.toStringHelper((Object)this).add("id", (Object)this.id).add("metadataItems", this.metadataItems).add("injectedFileContentBytes", this.injectedFileContentBytes).add("volumes", this.volumes).add("gigabytes", this.gigabytes).add("ram", this.ram).add("floatingIps", this.floatingIps).add("instances", this.instances).add("injectedFiles", this.injectedFiles).add("cores", this.cores).add("securityGroups", this.securityGroups).add("securityGroupRules", this.securityGroupRules).add("keyPairs", this.keyPairs);
    }

    public String toString() {
        return this.string().toString();
    }

    private static class ConcreteBuilder
    extends Builder<ConcreteBuilder> {
        private ConcreteBuilder() {
        }

        @Override
        protected ConcreteBuilder self() {
            return this;
        }
    }

    public static abstract class Builder<T extends Builder<T>> {
        protected String id;
        protected int metadataItems;
        protected int injectedFileContentBytes;
        protected int volumes;
        protected int gigabytes;
        protected int ram;
        protected int floatingIps;
        protected int instances;
        protected int injectedFiles;
        protected int cores;
        protected int securityGroups;
        protected int securityGroupRules;
        protected int keyPairs;

        protected abstract T self();

        public T id(String id) {
            this.id = id;
            return this.self();
        }

        public T metadataItems(int metadataItems) {
            this.metadataItems = metadataItems;
            return this.self();
        }

        public T injectedFileContentBytes(int injectedFileContentBytes) {
            this.injectedFileContentBytes = injectedFileContentBytes;
            return this.self();
        }

        public T volumes(int volumes) {
            this.volumes = volumes;
            return this.self();
        }

        public T gigabytes(int gigabytes) {
            this.gigabytes = gigabytes;
            return this.self();
        }

        public T ram(int ram) {
            this.ram = ram;
            return this.self();
        }

        public T floatingIps(int floatingIps) {
            this.floatingIps = floatingIps;
            return this.self();
        }

        public T instances(int instances) {
            this.instances = instances;
            return this.self();
        }

        public T injectedFiles(int injectedFiles) {
            this.injectedFiles = injectedFiles;
            return this.self();
        }

        public T cores(int cores) {
            this.cores = cores;
            return this.self();
        }

        public T securityGroups(int securityGroups) {
            this.securityGroups = securityGroups;
            return this.self();
        }

        public T securityGroupRules(int securityGroupRules) {
            this.securityGroupRules = securityGroupRules;
            return this.self();
        }

        public T keyPairs(int keyPairs) {
            this.keyPairs = keyPairs;
            return this.self();
        }

        public Quota build() {
            return new Quota(this.id, this.metadataItems, this.injectedFileContentBytes, this.volumes, this.gigabytes, this.ram, this.floatingIps, this.instances, this.injectedFiles, this.cores, this.securityGroups, this.securityGroupRules, this.keyPairs);
        }

        public T fromQuotas(Quota in) {
            return ((Builder)((Builder)((Builder)((Builder)((Builder)((Builder)((Builder)((Builder)((Builder)((Builder)((Builder)((Builder)this.id(in.getId())).metadataItems(in.getMetadatas())).injectedFileContentBytes(in.getInjectedFileContentBytes())).volumes(in.getVolumes())).gigabytes(in.getGigabytes())).ram(in.getRam())).floatingIps(in.getFloatingIps())).instances(in.getInstances())).injectedFiles(in.getInjectedFiles())).cores(in.getCores())).securityGroups(in.getSecurityGroups())).securityGroupRules(in.getSecurityGroupRules())).keyPairs(in.getKeyPairs());
        }
    }
}

