/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.openstack.nova.v2_0.domain;

import com.google.common.base.MoreObjects;
import com.google.common.base.Objects;
import com.google.common.base.Preconditions;
import jakarta.inject.Named;
import java.beans.ConstructorProperties;
import org.jclouds.javax.annotation.Nullable;

public class HostResourceUsage {
    private final String host;
    private final String project;
    @Named(value="memory_mb")
    private final int memoryMb;
    private final int cpu;
    @Named(value="disk_gb")
    private final int diskGb;

    public static Builder<?> builder() {
        return new ConcreteBuilder();
    }

    public Builder<?> toBuilder() {
        return new ConcreteBuilder().fromHostResourceUsage(this);
    }

    @ConstructorProperties(value={"host", "project", "memory_mb", "cpu", "disk_gb"})
    protected HostResourceUsage(String host, @Nullable String project, int memoryMb, int cpu, int diskGb) {
        this.host = (String)Preconditions.checkNotNull((Object)host, (Object)"host");
        this.project = project;
        this.memoryMb = memoryMb;
        this.cpu = cpu;
        this.diskGb = diskGb;
    }

    public String getHost() {
        return this.host;
    }

    @Nullable
    public String getProject() {
        return this.project;
    }

    public int getMemoryMb() {
        return this.memoryMb;
    }

    public int getCpu() {
        return this.cpu;
    }

    public int getDiskGb() {
        return this.diskGb;
    }

    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{this.host, this.project, this.memoryMb, this.cpu, this.diskGb});
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        HostResourceUsage that = (HostResourceUsage)HostResourceUsage.class.cast(obj);
        return Objects.equal((Object)this.host, (Object)that.host) && Objects.equal((Object)this.project, (Object)that.project) && Objects.equal((Object)this.memoryMb, (Object)that.memoryMb) && Objects.equal((Object)this.cpu, (Object)that.cpu) && Objects.equal((Object)this.diskGb, (Object)that.diskGb);
    }

    protected MoreObjects.ToStringHelper string() {
        return MoreObjects.toStringHelper((Object)this).add("host", (Object)this.host).add("project", (Object)this.project).add("memoryMb", this.memoryMb).add("cpu", this.cpu).add("diskGb", this.diskGb);
    }

    public String toString() {
        return this.string().toString();
    }

    private static class ConcreteBuilder
    extends Builder<ConcreteBuilder> {
        private ConcreteBuilder() {
        }

        @Override
        protected ConcreteBuilder self() {
            return this;
        }
    }

    public static abstract class Builder<T extends Builder<T>> {
        protected String host;
        protected String project;
        protected int memoryMb;
        protected int cpu;
        protected int diskGb;

        protected abstract T self();

        public T host(String host) {
            this.host = host;
            return this.self();
        }

        public T project(String project) {
            this.project = project;
            return this.self();
        }

        public T memoryMb(int memoryMb) {
            this.memoryMb = memoryMb;
            return this.self();
        }

        public T cpu(int cpu) {
            this.cpu = cpu;
            return this.self();
        }

        public T diskGb(int diskGb) {
            this.diskGb = diskGb;
            return this.self();
        }

        public HostResourceUsage build() {
            return new HostResourceUsage(this.host, this.project, this.memoryMb, this.cpu, this.diskGb);
        }

        public T fromHostResourceUsage(HostResourceUsage in) {
            return ((Builder)((Builder)((Builder)((Builder)this.host(in.getHost())).project(in.getProject())).memoryMb(in.getMemoryMb())).cpu(in.getCpu())).diskGb(in.getDiskGb());
        }
    }
}

