/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.openstack.nova.v2_0.domain;

import com.google.common.base.MoreObjects;
import com.google.common.base.Objects;
import com.google.common.base.Optional;
import com.google.common.base.Preconditions;
import jakarta.inject.Named;
import java.beans.ConstructorProperties;
import java.util.Set;
import org.jclouds.javax.annotation.Nullable;
import org.jclouds.openstack.v2_0.domain.Link;
import org.jclouds.openstack.v2_0.domain.Resource;

public class Flavor
extends Resource {
    private final int ram;
    private final int disk;
    private final int vcpus;
    private final Optional<String> swap;
    @Named(value="rxtx_factor")
    private final Optional<Double> rxtxFactor;
    @Named(value="OS-FLV-EXT-DATA:ephemeral")
    private final Optional<Integer> ephemeral;

    public static Builder<?> builder() {
        return new ConcreteBuilder();
    }

    public Builder<?> toBuilder() {
        return new ConcreteBuilder().fromFlavor(this);
    }

    @ConstructorProperties(value={"id", "name", "links", "ram", "disk", "vcpus", "swap", "rxtx_factor", "OS-FLV-EXT-DATA:ephemeral"})
    protected Flavor(String id, String name, Set<Link> links, int ram, int disk, int vcpus, @Nullable String swap, @Nullable Double rxtxFactor, @Nullable Integer ephemeral) {
        super(id, (String)Preconditions.checkNotNull((Object)name, (Object)"name"), links);
        Preconditions.checkArgument((ram > 0 ? 1 : 0) != 0, (Object)"Value of ram has to greater than 0");
        Preconditions.checkArgument((vcpus > 0 ? 1 : 0) != 0, (Object)"Value of vcpus has to greater than 0");
        this.ram = ram;
        this.disk = disk;
        this.vcpus = vcpus;
        this.swap = Optional.fromNullable((Object)swap);
        this.rxtxFactor = Optional.fromNullable((Object)rxtxFactor);
        this.ephemeral = Optional.fromNullable((Object)ephemeral);
    }

    public int getRam() {
        return this.ram;
    }

    public int getDisk() {
        return this.disk;
    }

    public int getVcpus() {
        return this.vcpus;
    }

    public Optional<String> getSwap() {
        return this.swap;
    }

    public Optional<Double> getRxtxFactor() {
        return this.rxtxFactor;
    }

    public Optional<Integer> getEphemeral() {
        return this.ephemeral;
    }

    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{this.ram, this.disk, this.vcpus, this.swap, this.rxtxFactor, this.ephemeral});
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || ((Object)((Object)this)).getClass() != obj.getClass()) {
            return false;
        }
        Flavor that = (Flavor)((Object)Flavor.class.cast(obj));
        return super.equals((Object)that) && Objects.equal((Object)this.ram, (Object)that.ram) && Objects.equal((Object)this.disk, (Object)that.disk) && Objects.equal((Object)this.vcpus, (Object)that.vcpus) && Objects.equal(this.swap, that.swap) && Objects.equal(this.rxtxFactor, that.rxtxFactor) && Objects.equal(this.ephemeral, that.ephemeral);
    }

    protected MoreObjects.ToStringHelper string() {
        return super.string().add("ram", this.ram).add("disk", this.disk).add("vcpus", this.vcpus).add("swap", this.swap).add("rxtxFactor", this.rxtxFactor).add("ephemeral", this.ephemeral);
    }

    private static class ConcreteBuilder
    extends Builder<ConcreteBuilder> {
        private ConcreteBuilder() {
        }

        protected ConcreteBuilder self() {
            return this;
        }
    }

    public static abstract class Builder<T extends Builder<T>>
    extends Resource.Builder<T> {
        protected int ram;
        protected int disk;
        protected int vcpus;
        protected String swap;
        protected Double rxtxFactor;
        protected Integer ephemeral;

        public T ram(int ram) {
            this.ram = ram;
            return (T)((Object)((Builder)this.self()));
        }

        public T disk(int disk) {
            this.disk = disk;
            return (T)((Object)((Builder)this.self()));
        }

        public T vcpus(int vcpus) {
            this.vcpus = vcpus;
            return (T)((Object)((Builder)this.self()));
        }

        public T swap(String swap) {
            this.swap = swap;
            return (T)((Object)((Builder)this.self()));
        }

        public T rxtxFactor(Double rxtxFactor) {
            this.rxtxFactor = rxtxFactor;
            return (T)((Object)((Builder)this.self()));
        }

        public T ephemeral(Integer ephemeral) {
            this.ephemeral = ephemeral;
            return (T)((Object)((Builder)this.self()));
        }

        public Flavor build() {
            return new Flavor(this.id, this.name, this.links, this.ram, this.disk, this.vcpus, this.swap, this.rxtxFactor, this.ephemeral);
        }

        public T fromFlavor(Flavor in) {
            return ((Builder)((Object)((Builder)((Object)((Builder)((Object)((Builder)((Object)((Builder)((Object)((Builder)super.fromResource((Resource)in)).ram(in.getRam()))).disk(in.getDisk()))).vcpus(in.getVcpus()))).swap((String)in.getSwap().orNull()))).rxtxFactor((Double)in.getRxtxFactor().orNull()))).ephemeral((Integer)in.getEphemeral().orNull());
        }
    }
}

