/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.openstack.nova.v2_0.compute.functions;

import com.google.common.base.Function;
import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import com.google.common.collect.Iterables;
import com.google.inject.assistedinject.Assisted;
import jakarta.annotation.Resource;
import jakarta.inject.Inject;
import jakarta.inject.Named;
import org.jclouds.compute.domain.SecurityGroup;
import org.jclouds.compute.domain.SecurityGroupBuilder;
import org.jclouds.domain.Location;
import org.jclouds.javax.annotation.Nullable;
import org.jclouds.logging.Logger;
import org.jclouds.net.domain.IpPermission;
import org.jclouds.openstack.nova.v2_0.domain.SecurityGroupRule;
import org.jclouds.openstack.nova.v2_0.domain.TenantIdAndName;

public class NovaSecurityGroupToSecurityGroup
implements Function<org.jclouds.openstack.nova.v2_0.domain.SecurityGroup, SecurityGroup> {
    @Resource
    @Named(value="jclouds.compute")
    protected Logger logger = Logger.NULL;
    private final Location location;

    @Inject
    public NovaSecurityGroupToSecurityGroup(@Assisted Location location) {
        this.location = location;
    }

    public SecurityGroup apply(@Nullable org.jclouds.openstack.nova.v2_0.domain.SecurityGroup group) {
        SecurityGroupBuilder builder = new SecurityGroupBuilder();
        builder.providerId(group.getId());
        builder.ownerId(group.getTenantId());
        builder.name(group.getName());
        String regionId = this.location.getId();
        builder.location(this.location);
        builder.id(regionId + "/" + group.getId());
        if (group.getRules() != null) {
            builder.ipPermissions(Iterables.filter((Iterable)Iterables.transform(group.getRules(), (Function)new Function<SecurityGroupRule, IpPermission>(){

                public IpPermission apply(SecurityGroupRule input) {
                    return NovaSecurityGroupToSecurityGroup.this.securityGroupRuleToIpPermission(input);
                }
            }), (Predicate)Predicates.notNull()));
        }
        return builder.build();
    }

    private IpPermission securityGroupRuleToIpPermission(SecurityGroupRule rule) {
        IpPermission.Builder builder = IpPermission.builder();
        builder.ipProtocol(rule.getIpProtocol());
        builder.fromPort(rule.getFromPort());
        builder.toPort(rule.getToPort());
        TenantIdAndName ruleGroup = rule.getGroup();
        if (ruleGroup != null) {
            builder.groupId(this.location.getId() + "/" + ruleGroup.getTenantId());
        }
        if (rule.getIpRange() != null) {
            builder.cidrBlock(rule.getIpRange());
        }
        return builder.build();
    }

    public static interface Factory {
        public NovaSecurityGroupToSecurityGroup create(Location var1);
    }
}

