/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.openstack.nova.v2_0.compute.functions;

import com.google.common.base.Function;
import com.google.common.base.Preconditions;
import com.google.common.base.Predicate;
import com.google.common.cache.LoadingCache;
import com.google.common.collect.FluentIterable;
import jakarta.annotation.Resource;
import jakarta.inject.Inject;
import jakarta.inject.Named;
import jakarta.inject.Singleton;
import java.util.Set;
import org.jclouds.compute.domain.NodeMetadata;
import org.jclouds.compute.domain.SecurityGroup;
import org.jclouds.compute.extensions.SecurityGroupExtension;
import org.jclouds.logging.Logger;
import org.jclouds.openstack.nova.v2_0.compute.functions.RemoveFloatingIpFromNodeAndDeallocate;
import org.jclouds.openstack.nova.v2_0.domain.regionscoped.RegionAndId;
import org.jclouds.openstack.nova.v2_0.domain.regionscoped.RegionAndName;

@Singleton
public class CleanupResources
implements Function<NodeMetadata, Boolean> {
    @Resource
    @Named(value="jclouds.compute")
    protected Logger logger = Logger.NULL;
    protected final RemoveFloatingIpFromNodeAndDeallocate removeFloatingIpFromNodeAndDeallocate;
    protected final LoadingCache<RegionAndName, SecurityGroup> securityGroupMap;
    private final SecurityGroupExtension securityGroupExtension;

    @Inject
    public CleanupResources(RemoveFloatingIpFromNodeAndDeallocate removeFloatingIpFromNodeAndDeallocate, LoadingCache<RegionAndName, SecurityGroup> securityGroupMap, SecurityGroupExtension securityGroupExtension) {
        this.removeFloatingIpFromNodeAndDeallocate = removeFloatingIpFromNodeAndDeallocate;
        this.securityGroupMap = (LoadingCache)Preconditions.checkNotNull(securityGroupMap, (Object)"securityGroupMap");
        this.securityGroupExtension = securityGroupExtension;
    }

    public Boolean apply(NodeMetadata node) {
        RegionAndId regionAndId = RegionAndId.fromSlashEncoded(node.getId());
        this.removeFloatingIpFromNodeifAny(regionAndId);
        return this.removeSecurityGroupCreatedByJcloudsAndInvalidateCache(node.getTags());
    }

    public boolean removeSecurityGroupCreatedByJcloudsAndInvalidateCache(Set<String> tags) {
        String securityGroupIdCreatedByJclouds = this.getSecurityGroupIdCreatedByJclouds(tags);
        if (securityGroupIdCreatedByJclouds == null) {
            return true;
        }
        return this.securityGroupExtension.removeSecurityGroup(securityGroupIdCreatedByJclouds);
    }

    private void removeFloatingIpFromNodeifAny(RegionAndId regionAndId) {
        try {
            this.removeFloatingIpFromNodeAndDeallocate.apply(regionAndId);
        }
        catch (RuntimeException e) {
            this.logger.warn((Throwable)e, "<< error removing and deallocating ip from node(%s): %s", new Object[]{regionAndId, e.getMessage()});
        }
    }

    private String getSecurityGroupIdCreatedByJclouds(Set<String> tags) {
        return (String)FluentIterable.from(tags).filter((Predicate)new Predicate<String>(){

            public boolean apply(String input) {
                return input.startsWith("jclouds_sg");
            }
        }).transform((Function)new Function<String, String>(){

            public String apply(String input) {
                return input.substring("jclouds_sg".length() + 1);
            }
        }).first().orNull();
    }
}

