/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.openstack.neutron.v2.functions.lbaas.v1;

import com.google.common.base.Function;
import com.google.common.base.Optional;
import com.google.common.base.Preconditions;
import jakarta.inject.Inject;
import org.jclouds.collect.IterableWithMarker;
import org.jclouds.collect.internal.Arg0ToPagedIterable;
import org.jclouds.openstack.neutron.v2.NeutronApi;
import org.jclouds.openstack.neutron.v2.domain.lbaas.v1.VIP;
import org.jclouds.openstack.neutron.v2.extensions.lbaas.v1.LBaaSApi;
import org.jclouds.openstack.v2_0.options.PaginationOptions;

public class VIPsToPagedIterable
extends Arg0ToPagedIterable.FromCaller<VIP, VIPsToPagedIterable> {
    private final NeutronApi api;

    @Inject
    protected VIPsToPagedIterable(NeutronApi api) {
        this.api = (NeutronApi)Preconditions.checkNotNull((Object)api, (Object)"api");
    }

    protected Function<Object, IterableWithMarker<VIP>> markerToNextForArg0(Optional<Object> arg0) {
        String region = arg0.isPresent() ? arg0.get().toString() : null;
        final LBaaSApi lbaasApi = (LBaaSApi)this.api.getLBaaSApi(region).get();
        return new Function<Object, IterableWithMarker<VIP>>(){

            public IterableWithMarker<VIP> apply(Object input) {
                PaginationOptions paginationOptions = (PaginationOptions)PaginationOptions.class.cast(input);
                return (IterableWithMarker)IterableWithMarker.class.cast((Object)lbaasApi.listVIPs(paginationOptions));
            }

            public String toString() {
                return "listVIPs()";
            }
        };
    }
}

