/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.openstack.neutron.v2.functions;

import com.google.common.base.Function;
import com.google.common.base.Optional;
import com.google.common.base.Preconditions;
import jakarta.inject.Inject;
import org.jclouds.collect.IterableWithMarker;
import org.jclouds.collect.internal.Arg0ToPagedIterable;
import org.jclouds.openstack.neutron.v2.NeutronApi;
import org.jclouds.openstack.neutron.v2.domain.Rule;
import org.jclouds.openstack.neutron.v2.features.SecurityGroupApi;
import org.jclouds.openstack.v2_0.options.PaginationOptions;

public class RulesToPagedIterable
extends Arg0ToPagedIterable.FromCaller<Rule, RulesToPagedIterable> {
    private final NeutronApi api;

    @Inject
    protected RulesToPagedIterable(NeutronApi api) {
        this.api = (NeutronApi)Preconditions.checkNotNull((Object)api, (Object)"api");
    }

    protected Function<Object, IterableWithMarker<Rule>> markerToNextForArg0(Optional<Object> arg0) {
        String region = arg0.isPresent() ? arg0.get().toString() : null;
        final SecurityGroupApi securityGroupApi = this.api.getSecurityGroupApi(region);
        return new Function<Object, IterableWithMarker<Rule>>(){

            public IterableWithMarker<Rule> apply(Object input) {
                PaginationOptions paginationOptions = (PaginationOptions)PaginationOptions.class.cast(input);
                return (IterableWithMarker)IterableWithMarker.class.cast((Object)securityGroupApi.listRules(paginationOptions));
            }

            public String toString() {
                return "listRules()";
            }
        };
    }
}

