/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.openstack.neutron.v2.functions;

import com.google.common.base.Function;
import com.google.common.base.Optional;
import com.google.common.base.Preconditions;
import jakarta.inject.Inject;
import org.jclouds.collect.IterableWithMarker;
import org.jclouds.collect.internal.Arg0ToPagedIterable;
import org.jclouds.openstack.neutron.v2.NeutronApi;
import org.jclouds.openstack.neutron.v2.domain.Router;
import org.jclouds.openstack.neutron.v2.extensions.RouterApi;
import org.jclouds.openstack.v2_0.options.PaginationOptions;

public class RouterToPagedIterable
extends Arg0ToPagedIterable.FromCaller<Router, RouterToPagedIterable> {
    private final NeutronApi api;

    @Inject
    protected RouterToPagedIterable(NeutronApi api) {
        this.api = (NeutronApi)Preconditions.checkNotNull((Object)api, (Object)"api");
    }

    protected Function<Object, IterableWithMarker<Router>> markerToNextForArg0(Optional<Object> arg0) {
        String region = arg0.isPresent() ? arg0.get().toString() : null;
        final RouterApi routerApi = (RouterApi)this.api.getRouterApi(region).get();
        return new Function<Object, IterableWithMarker<Router>>(){

            public IterableWithMarker<Router> apply(Object input) {
                PaginationOptions paginationOptions = (PaginationOptions)PaginationOptions.class.cast(input);
                return (IterableWithMarker)IterableWithMarker.class.cast((Object)routerApi.list(paginationOptions));
            }

            public String toString() {
                return "listRouters()";
            }
        };
    }
}

