/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.openstack.neutron.v2.functions;

import com.google.common.base.Function;
import com.google.common.base.Optional;
import com.google.common.base.Preconditions;
import jakarta.inject.Inject;
import org.jclouds.collect.IterableWithMarker;
import org.jclouds.collect.internal.Arg0ToPagedIterable;
import org.jclouds.openstack.neutron.v2.NeutronApi;
import org.jclouds.openstack.neutron.v2.domain.Network;
import org.jclouds.openstack.neutron.v2.features.NetworkApi;
import org.jclouds.openstack.v2_0.options.PaginationOptions;

public class NetworksToPagedIterable
extends Arg0ToPagedIterable.FromCaller<Network, NetworksToPagedIterable> {
    private final NeutronApi api;

    @Inject
    protected NetworksToPagedIterable(NeutronApi api) {
        this.api = (NeutronApi)Preconditions.checkNotNull((Object)api, (Object)"api");
    }

    protected Function<Object, IterableWithMarker<Network>> markerToNextForArg0(Optional<Object> arg0) {
        String region = arg0.isPresent() ? arg0.get().toString() : null;
        final NetworkApi networkApi = this.api.getNetworkApi(region);
        return new Function<Object, IterableWithMarker<Network>>(){

            public IterableWithMarker<Network> apply(Object input) {
                PaginationOptions paginationOptions = (PaginationOptions)PaginationOptions.class.cast(input);
                return (IterableWithMarker)IterableWithMarker.class.cast((Object)networkApi.list(paginationOptions));
            }

            public String toString() {
                return "listNetworks()";
            }
        };
    }
}

