/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.openstack.neutron.v2.functions;

import com.google.common.base.Function;
import com.google.common.base.Optional;
import com.google.common.base.Preconditions;
import jakarta.inject.Inject;
import org.jclouds.collect.IterableWithMarker;
import org.jclouds.collect.internal.Arg0ToPagedIterable;
import org.jclouds.openstack.neutron.v2.NeutronApi;
import org.jclouds.openstack.neutron.v2.domain.Firewall;
import org.jclouds.openstack.neutron.v2.extensions.FWaaSApi;

public class FirewallToPagedIterable
extends Arg0ToPagedIterable.FromCaller<Firewall, FirewallToPagedIterable> {
    private final NeutronApi api;

    @Inject
    protected FirewallToPagedIterable(NeutronApi api) {
        this.api = (NeutronApi)Preconditions.checkNotNull((Object)api, (Object)"api");
    }

    protected Function<Object, IterableWithMarker<Firewall>> markerToNextForArg0(Optional<Object> arg0) {
        String region = arg0.isPresent() ? arg0.get().toString() : null;
        final FWaaSApi firewallApi = (FWaaSApi)this.api.getFWaaSApi(region).get();
        return new Function<Object, IterableWithMarker<Firewall>>(){

            public IterableWithMarker<Firewall> apply(Object input) {
                return (IterableWithMarker)IterableWithMarker.class.cast(firewallApi.list());
            }

            public String toString() {
                return "listFirewalls()";
            }
        };
    }
}

