/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.openstack.neutron.v2.features;

import com.google.common.annotations.Beta;
import com.google.common.collect.FluentIterable;
import com.google.common.collect.ImmutableList;
import jakarta.inject.Named;
import jakarta.ws.rs.Consumes;
import jakarta.ws.rs.DELETE;
import jakarta.ws.rs.GET;
import jakarta.ws.rs.POST;
import jakarta.ws.rs.PUT;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.PathParam;
import jakarta.ws.rs.Produces;
import org.jclouds.Fallbacks;
import org.jclouds.collect.PagedIterable;
import org.jclouds.javax.annotation.Nullable;
import org.jclouds.openstack.keystone.auth.filters.AuthenticateRequest;
import org.jclouds.openstack.neutron.v2.domain.Network;
import org.jclouds.openstack.neutron.v2.domain.Networks;
import org.jclouds.openstack.neutron.v2.fallbacks.EmptyNetworksFallback;
import org.jclouds.openstack.neutron.v2.functions.NetworksToPagedIterable;
import org.jclouds.openstack.neutron.v2.functions.ParseNetworks;
import org.jclouds.openstack.v2_0.options.PaginationOptions;
import org.jclouds.rest.annotations.Fallback;
import org.jclouds.rest.annotations.RequestFilters;
import org.jclouds.rest.annotations.ResponseParser;
import org.jclouds.rest.annotations.SelectJson;
import org.jclouds.rest.annotations.Transform;
import org.jclouds.rest.annotations.WrapWith;

@Path(value="/networks")
@RequestFilters(value={AuthenticateRequest.class})
@Consumes(value={"application/json"})
@Produces(value={"application/json"})
@Beta
public interface NetworkApi {
    @Named(value="network:list")
    @GET
    @ResponseParser(value=ParseNetworks.class)
    @Transform(value=NetworksToPagedIterable.class)
    @Fallback(value=Fallbacks.EmptyPagedIterableOnNotFoundOr404.class)
    public PagedIterable<Network> list();

    @Named(value="network:list")
    @GET
    @ResponseParser(value=ParseNetworks.class)
    @Fallback(value=EmptyNetworksFallback.class)
    public Networks list(PaginationOptions var1);

    @Named(value="network:get")
    @GET
    @Path(value="/{id}")
    @SelectJson(value={"network"})
    @Fallback(value=Fallbacks.NullOnNotFoundOr404.class)
    @Nullable
    public Network get(@PathParam(value="id") String var1);

    @Named(value="network:create")
    @POST
    @SelectJson(value={"network"})
    public Network create(@WrapWith(value="network") Network.CreateNetwork var1);

    @Named(value="network:createBulk")
    @POST
    @SelectJson(value={"networks"})
    public FluentIterable<Network> createBulk(@WrapWith(value="networks") ImmutableList<Network.CreateNetwork> var1);

    @Named(value="network:update")
    @PUT
    @Path(value="/{id}")
    @SelectJson(value={"network"})
    public Network update(@PathParam(value="id") String var1, @WrapWith(value="network") Network.UpdateNetwork var2);

    @Named(value="network:delete")
    @DELETE
    @Path(value="/{id}")
    @Fallback(value=Fallbacks.FalseOnNotFoundOr404.class)
    public boolean delete(@PathParam(value="id") String var1);
}

